package gov.va.nvap.server.service.pdq.filter;

import gov.va.nvap.common.filter.Filter;
import gov.va.nvap.common.filter.FilterException;
import gov.va.nvap.common.validation.NullChecker;
/*
 import gov.va.nvap.svc.consentmgmt.PIPInterface;

import gov.va.nvap.svc.consentmgmt.stub.data.Facility;
 */
import gov.va.nvap.svc.facility.data.Facility;
import gov.va.nvap.svc.facility.intf.FacilityService;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Required;

/**
 * Filter by VA facility.
 * 
 * @author Asha Amritraj
 */
public class FacilityNumberFilter implements
		Filter<Map<String, String>, Map<String, String>>, InitializingBean {
	/**
	 * Get the list of allowed facilities from the PIP and store them.
	 */
	List<String> allowedFacilities;
	/**
	 * Reference to PIP.
	 */
	//PIPInterface pip;
	FacilityService facService;

	@Override
	public void afterPropertiesSet() throws Exception {
		final Collection<Facility> facilities = this.facService
				.getAllowedVistAFacilities();
		this.allowedFacilities = new ArrayList<String>();
		if (NullChecker.isNotEmpty(facilities)) {
			for (final Facility facility : facilities) {
				this.allowedFacilities.add(facility.getFacilityStation());
			}
		}
	}

	@Override
	public Map<String, String> filter(final Map<String, String> responses)
			throws FilterException {
		if (NullChecker.isEmpty(responses)
				|| (NullChecker.isNotEmpty(responses) && (responses.size() == 1))) {
			return responses;
		}

		// If it is one of the allowed facilities, return that MPI correlation
		// response.
		// Use that response to populate patient demographics.
		final Map<String, String> allowedMap = new HashMap<String, String>();
		for (final String responseKey : responses.keySet()) {
			for (final String allowedFacility : this.allowedFacilities) {
				if (allowedFacility.equals(responseKey)) {
					allowedMap.put(responseKey, responses.get(responseKey));
				}
			}
		}

		if (allowedMap.isEmpty()) {
			return responses;
		} else {
			return allowedMap;
		}

	}
	
	@Required
	public void setFacService(final FacilityService facilityService) {
		this.facService = facilityService;
	}
	/*
	@Required
	public void setPip(final PIPInterface pipInterface) {
		this.pip = pipInterface;
	}
	*/
}
