/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.nvap.server.service.partner;

import gov.va.nvap.partner.Partner;
import gov.va.nvap.service.partner.PartnerOnboardingException;
import java.util.List;

import javax.ejb.Local;

/**
 * 
 * @author vhaislegberb
 */
@Local
public interface PartnerOnboardingBeanLocal {

	/**
	 * Business method for adding a new partner organization to the VAP system.
	 * This could also be the point at which further (down-stream) on-boarding
	 * activities could be triggered to notify other systems of the changes to
	 * the supported partners.
	 * 
	 * @param partner
	 *            The partner to be added.
	 * @param announce
	 *            Announce the patients to the new partner.
	 * @throws PartnerOnboardingException
	 *             In the event that the partner could not be added.
	 */
	void addPartner(final Partner partner, Boolean announce)
			throws PartnerOnboardingException;

	/**
	 * Sets the partner as active if the activate flag is set to true; otherwise
	 * set the partner to inactive.
	 * 
	 * @param activate
	 * @param oid
	 *            The OID of the partner which is being activated or
	 *            deactivated..
	 * @throws PartnerOnboardingException
	 *             In the event that the setting of the status flag fails.
	 */
	void setPartnerActiveFlag(Boolean activate, String oid)
			throws PartnerOnboardingException;
    
    /**
     * Gets a list of organizations and updates or adds missing ones
     *
     * @param partners List of partners to be added or modified.
     * @param announce announce all patients to new partners
     *
     * The OID of the partner which is being activated or deactivated..
     * @throws PartnerOnboardingException In the event that it could not add a partner or other error arrises
     */
    void updatePartnerList(List<Partner> partners, Boolean announce)
        throws PartnerOnboardingException;

}
