/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.nvap.server.service.partner;

import gov.va.nvap.partner.Partner;
import gov.va.nvap.server.auth.ServiceAuthentication;
import gov.va.nvap.service.auth.ServiceAudit;
import gov.va.nvap.service.auth.ServiceAuthenticationException;
import gov.va.nvap.service.partner.PartnerOnboardingException;
import gov.va.nvap.svc.consentmgmt.PIPInterface;
import gov.va.nvap.svc.consentmgmt.stub.adapter.announce.data.AnnouncerInterface;
import gov.va.nvap.svc.consentmgmt.stub.adapter.announce.data.PatientConsentBatchAnnounce;
import gov.va.nvap.svc.consentmgmt.stub.data.Organization;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import javax.ejb.Stateless;
import javax.interceptor.Interceptors;
import javax.jws.WebService;
import javax.xml.ws.WebServiceContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.ejb.interceptor.SpringBeanAutowiringInterceptor;

/**
 * 
 * @author vhaislegberb
 */
@Stateless
@WebService(endpointInterface = "gov.va.nvap.service.partner.PartnerOnboardingService")
@Interceptors(SpringBeanAutowiringInterceptor.class)
public class PartnerOnboardingBean implements PartnerOnboardingBeanLocal {

	@Autowired
	private AnnouncerInterface announcer;

	@Autowired
	private PatientConsentBatchAnnounce batchAnnouncer;

	@Autowired
	private PIPInterface policyInformationPoint;
        
        @Autowired
        private ApplicationContext applicationContext;
        @Resource
        private WebServiceContext context;
        private ServiceAuthentication auth = new ServiceAuthentication();
	@Override
	public void addPartner(final Partner partner, final Boolean announce)
			throws PartnerOnboardingException {
        
        ServiceAudit sa = new ServiceAudit();
        Integer success = 1;
        
        try{
            sa = auth.checkAuth(context,applicationContext,"addPartner");
        }catch (ServiceAuthenticationException ex) {
            return;
        }
        
        long startTime = System.currentTimeMillis();
        
		try {
			final Organization org = new Organization();
			org.setOrgCommunityIdPrefix(partner.getCommunityIdPrefix());
			org.setOrgContact(partner.getContact());
			org.setOrgDomain(partner.getDomain());
			org.setOrgName(partner.getName());
			org.setOrgNumber(partner.getNumber());
			org.setOrgOid(partner.getOid());
			org.setOrgPhoneNumber(partner.getPhoneNumber());
			org.setActive('Y');
                        org.setIsTrustedClinicalSource('N');
                        org.setOrgConsumerOnly('N');

			// persist the organization.
			this.policyInformationPoint.storeOrganization(org);

			// potentially you could do more onboarding stuff here.

			if (announce) {
				// do a targeted batch announce to the new partner
				// TODO: Validate SYSTEM user as the automated on-boarding batch
				// processor
				final String batchId = this.announcer.createAnnouncementsBatch(
						org, "SYSTEM", null, null, true);
				if (null != batchId) {
					this.batchAnnouncer.batchAnnounce(new String[] { batchId },
							"SYSTEM", "PartnerOnboardingBean");
				}
			}

		} catch (final Exception ex) {
            success = 0;
			throw new PartnerOnboardingException(
					"Error adding the partner organization.", ex);
		} finally {
            if (sa != null) {
                sa.setSuccess(success);
                sa.setDuration((int) (System.currentTimeMillis() - startTime));
                auth.persist(applicationContext, sa);
            }
        }
	}

	public void setAnnouncer(final AnnouncerInterface announcer) {
        ServiceAudit sa = new ServiceAudit();
        Integer success = 1;
        long startTime = System.currentTimeMillis();
        
        try{
            sa =auth.checkAuth(context,applicationContext,"setAnnouncer");
        }catch (ServiceAuthenticationException ex) {
            success = 0;
            return;
        } finally {
            if (sa != null) {
                sa.setSuccess(success);
                sa.setDuration((int) (System.currentTimeMillis() - startTime));
                auth.persist(applicationContext, sa);
            }
        }
        
        this.announcer = announcer;
	}

	/**
	 * 
	 * @param batchAnnouncer
	 */
	public void setBatchAnnouncer(final PatientConsentBatchAnnounce batchAnnouncer) {
        ServiceAudit sa = new ServiceAudit();
        Integer success = 1;
        long startTime = System.currentTimeMillis();
        
        try{    
            sa = auth.checkAuth(context,applicationContext,"setBatchAnnouncer");
        }catch (ServiceAuthenticationException ex) {
            success = 0;
            return;
        } finally {
            if (sa != null) {
                sa.setSuccess(success);
                sa.setDuration((int) (System.currentTimeMillis() - startTime));
                auth.persist(applicationContext, sa);
            }
        }
        
		this.batchAnnouncer = batchAnnouncer;
	}

	@Override
	public void setPartnerActiveFlag(final Boolean activate, final String oid) throws PartnerOnboardingException {
        ServiceAudit sa = new ServiceAudit();
        Integer success = 1;
        
        try{
            sa = auth.checkAuth(context,applicationContext,"setPartnerActiveFlag");
        }catch (ServiceAuthenticationException ex) {
            return;
        }	
        
        long startTime = System.currentTimeMillis();
        
        try {
            final Organization org = this.policyInformationPoint.getOrganizationByOid(oid);
            if (org == null) {
                throw new PartnerOnboardingException(
                        String.format(
                                "The Organization with OID: %s does not exist in the system.",
                                oid));
            }
			org.setActive((activate) ? 'Y' : 'N');

			this.policyInformationPoint.storeOrganization(org);
		} catch (final PartnerOnboardingException poe) {
            success = 0;
			throw poe;
		} catch (final Exception ex) {
            success = 0;
			throw new PartnerOnboardingException("Error setting Partner active flag.", ex);
		} finally {
            if (sa != null) {
                sa.setSuccess(success);
                sa.setDuration((int) (System.currentTimeMillis() - startTime));
                auth.persist(applicationContext, sa);
            }
        }
	}

	/**
	 * 
	 * @param policyInformationPoint
	 */
	public void setPolicyInformationPoint(final PIPInterface policyInformationPoint) {
        ServiceAudit sa = new ServiceAudit();
        Integer success = 1;
        long startTime = System.currentTimeMillis();
        
        try {
            sa = auth.checkAuth(context,applicationContext,"setPolicyInformationPoint");
         }catch (ServiceAuthenticationException ex) {
            success = 0;
            return;
        } finally {
            if (sa != null) {
                sa.setSuccess(success);
                sa.setDuration((int) (System.currentTimeMillis() - startTime));
                auth.persist(applicationContext, sa);
            }
        }
		
        this.policyInformationPoint = policyInformationPoint;
	}
    
    @Override
    public void updatePartnerList(List<Partner> partners, Boolean announce) throws PartnerOnboardingException {
        ServiceAudit sa = new ServiceAudit();
        Integer success = 1;

        try {
            sa = auth.checkAuth(context, applicationContext, "setPartnerActiveFlag");
        } catch (ServiceAuthenticationException ex) {
            return;
        }

        long startTime = System.currentTimeMillis();

        try {
            final Collection<Organization> orgs = this.policyInformationPoint.getAllowedOrganizations();
            for (Partner p : partners) {
                if (p.getCommunityIdPrefix() == null || p.getDomain() == null || p.getNumber() == null || p.getName() == null || p.getOid() == null) {
                    success = 0;
                    throw new PartnerOnboardingException("Partner " + p.getNumber() + "(" + p.getNumber() + ") does not have all the requred information.");
                }
                Boolean found = false;
                for (Organization org : orgs) {
                    if (p.getNumber().equals(org.getOrgNumber())) {
                        found = true;
                        org.setOrgCommunityIdPrefix(p.getCommunityIdPrefix());
                        org.setOrgDomain(p.getDomain());
                        org.setOrgName(p.getName());
                        if (p.getContact() != null) {
                            org.setOrgContact(p.getContact());
                        }
                        if (p.getPhoneNumber() != null) {
                            org.setOrgPhoneNumber(p.getPhoneNumber());
                        }
                        org.setOrgOid(p.getOid());
                        this.policyInformationPoint.storeOrganization(org);
                        break;
                    }
                }
                if (!found) {
                    this.addPartner(p, announce);
                }
            }
        } catch (final Exception ex) {
            success = 0;
            throw new PartnerOnboardingException("Error updating partners.", ex);
        } finally {
            if (sa != null) {
                sa.setSuccess(success);
                sa.setDuration((int) (System.currentTimeMillis() - startTime));
                auth.persist(applicationContext, sa);
            }
        }

    }
}
