package gov.va.nvap.server.service.forms;

import gov.va.nvap.server.auth.ServiceAuthentication;
import gov.va.nvap.service.auth.ServiceAudit;
import gov.va.nvap.service.auth.ServiceAuthenticationException;
import gov.va.nvap.service.forms.FormsStorageException;
import gov.va.nvap.service.forms.PatientForm;
import gov.va.nvap.service.forms.PatientFormDAO;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.ejb.Stateless;
import javax.interceptor.Interceptors;
import javax.jws.WebService;
import javax.xml.ws.WebServiceContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.ejb.interceptor.SpringBeanAutowiringInterceptor;

/**
 *
 * @since 01/06/2016
 * @author Elan
 */
@Stateless(name = "FormsStorage", mappedName = "FormsStorage")
@WebService(endpointInterface = "gov.va.nvap.service.forms.FormsStorageService")
@Interceptors(SpringBeanAutowiringInterceptor.class)
public class FormsStorage {

    @Autowired
    private ApplicationContext applicationContext;
    @Resource
    private WebServiceContext context;
    private final ServiceAuthentication auth = new ServiceAuthentication();

    public Long addPatientForm(final String ien, final String document, String formType)
        throws FormsStorageException {
        ServiceAudit sa;
        Integer success = 1;
        try {
            sa = auth.checkAuth(context, applicationContext, "addPatientForm");
        } catch (ServiceAuthenticationException ex) {
            return null;
        }

        long startTime = System.currentTimeMillis();

        try {
            PatientForm pf = new PatientForm();
            try {
                pf.setDocument(document);
            } catch (Exception e) {
                throw new FormsStorageException("Document could not be store.  Requires Base64 encoding.");
            }

            pf.setPatientID(ien);
            pf.setDocumentType(formType);
            pf.setDateAdded(new Date());

            PatientFormDAO dao = applicationContext.getBean(PatientFormDAO.class);

            return dao.create(pf);
        } catch (final Exception ex) {
            success = 0;
            throw new FormsStorageException("Error adding form to VAP", ex);
        } finally {
            if (sa != null) {
                sa.setSuccess(success);
                sa.setDuration((int) (System.currentTimeMillis() - startTime));
                auth.persist(applicationContext, sa);
            }
        }
    }

    public List<Long> getPatientFormIDs(final String ien, final String documentType)
        throws FormsStorageException {
        ServiceAudit sa;
        Integer success = 1;

        try {
            sa = auth.checkAuth(context, applicationContext, "getPatientFormIDs");
        } catch (ServiceAuthenticationException ex) {
            return null;
        }

        long startTime = System.currentTimeMillis();

        try {
            PatientFormDAO dao = applicationContext.getBean(PatientFormDAO.class);

            List<Long> ids = dao.findPatientFormIDs(ien, documentType);
            return ids;
        } catch (final Exception ex) {
            success = 0;
            throw new FormsStorageException("Error getting patient form IDs", ex);
        } finally {
            if (sa != null) {
                sa.setSuccess(success);
                sa.setDuration((int) (System.currentTimeMillis() - startTime));
                auth.persist(applicationContext, sa);
            }
        }

    }

    public PatientForm getPatientForm(final Long docID)
        throws FormsStorageException {
        ServiceAudit sa;
        Integer success = 1;

        try {
            sa = auth.checkAuth(context, applicationContext, "getPatientForm");
        } catch (ServiceAuthenticationException ex) {
            return null;
        }

        long startTime = System.currentTimeMillis();

        try {
            PatientFormDAO dao = applicationContext.getBean(PatientFormDAO.class);
            return dao.findPatientForm(docID);
        } catch (final Exception ex) {
            success = 0;
            throw new FormsStorageException("Error getting patient form", ex);
        } finally {
            if (sa != null) {
                sa.setSuccess(success);
                sa.setDuration((int) (System.currentTimeMillis() - startTime));
                auth.persist(applicationContext, sa);
            }
        }
    }

    public PatientForm getLatestPatientForm(final String patientID,
        final String documentType)
        throws FormsStorageException {
        ServiceAudit sa;
        Integer success = 1;

        try {
            sa = auth.checkAuth(context, applicationContext, "getLatestPatientForm");
        } catch (ServiceAuthenticationException ex) {
            return null;
        }

        long startTime = System.currentTimeMillis();

        try {
            PatientFormDAO dao = applicationContext.getBean(PatientFormDAO.class);
            return dao.findLastestPatientForm(patientID, documentType);
        } catch (final Exception ex) {
            success = 0;
            throw new FormsStorageException("Error getting patient form", ex);
        } finally {
            if (sa != null) {
                sa.setSuccess(success);
                sa.setDuration((int) (System.currentTimeMillis() - startTime));
                auth.persist(applicationContext, sa);
            }
        }
    }
    
}
