package gov.va.nvap.server.service.audit;

import gov.va.nvap.privacy.ConsentType;
import gov.va.nvap.service.audit.AuditException;
import gov.va.nvap.service.audit.AuditService;
import gov.va.nvap.service.audit.data.ConsentAudit;
import gov.va.nvap.service.audit.data.UserAccessAudit;
import gov.va.nvap.svc.consentmgmt.stub.data.Authority;

import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;

public class AuditServiceImpl implements AuditService {

	@PersistenceContext()
	private EntityManager entityManager;

	public AuditServiceImpl() {
	}

	@Override
	public void auditConsent(final ConsentAudit consentAudit)
			throws AuditException {
		this.entityManager.persist(consentAudit);

	}

	@Override
	public void auditUserAccess(final UserAccessAudit userAccessAudit)
			throws AuditException {
		this.entityManager.persist(userAccessAudit);
	}

	public void setEntityManager(final EntityManager entityManager) {
		this.entityManager = entityManager;
	}

    @Override
    public ConsentAudit getLatestAudit(String patientID, String consentType) {
        try {
			final Query q = this.entityManager.createNamedQuery("ConsentAudit.getLatestAudit");
			q.setParameter("patientId", patientID);
                        q.setParameter("consentType", consentType);
                        q.setMaxResults(1);
			return (ConsentAudit) q.getSingleResult();
		} catch (final NoResultException nre) {
			// expected
			return null;
		}
    }

}
