package gov.va.nvap.server.endpoint.pip;

import gov.va.nvap.privacy.ConsentDirectiveDetailedExpirationRequest;
import gov.va.nvap.svc.consentmgmt.PIPInterface;
import gov.va.nvap.svc.consentmgmt.PolicyConstraints;
import gov.va.nvap.svc.consentmgmt.stub.adapter.announce.data.Announcement;
import gov.va.nvap.svc.consentmgmt.stub.adapter.announce.data.AnnouncementOrg;
import gov.va.nvap.svc.consentmgmt.stub.data.ConsentDirective;
import gov.va.nvap.svc.consentmgmt.stub.data.ConsentType;
import gov.va.nvap.svc.consentmgmt.stub.data.DetailedConsentDirective;
import gov.va.nvap.svc.consentmgmt.stub.data.ExpiringConsentConfiguration;
import gov.va.nvap.svc.consentmgmt.stub.data.Facility;
import gov.va.nvap.svc.consentmgmt.stub.data.FacilityOptInConsent;
import gov.va.nvap.svc.consentmgmt.stub.data.FunctionalRole;
import gov.va.nvap.svc.consentmgmt.stub.data.Location;
import gov.va.nvap.svc.consentmgmt.stub.data.OptoutReason;
import gov.va.nvap.svc.consentmgmt.stub.data.Organization;
import gov.va.nvap.svc.consentmgmt.stub.data.PatientDocument;
import gov.va.nvap.svc.consentmgmt.stub.data.PatientDocumentType;
import gov.va.nvap.svc.consentmgmt.stub.data.PurposeOfUse;
import java.util.Collection;
import javax.ejb.Stateless;
import javax.interceptor.Interceptors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.ejb.interceptor.SpringBeanAutowiringInterceptor;

/**
 * A facade for the Policy Information Point (PIP). Used by the GUI.
 *
 * @author Asha Amritraj
 *
 */
@Stateless(name = "PipService", mappedName = "PipService")
@javax.ejb.Remote(PIPInterface.class)
@Interceptors(SpringBeanAutowiringInterceptor.class)
public class PolicyInformationPointFacade implements PIPInterface {

    /**
     * Spring injection, so that all the dependencies are injected.
     */
    @Autowired
    @Qualifier(value = "PolicyInformationPoint")
    PIPInterface pip;

    @Override
    public ConsentDirective getActiveConsentDirective(
        final Collection<String> patientIens, final ConsentType consentType) {
        return this.pip.getActiveConsentDirective(patientIens, consentType);
    }

    @Override
    public Collection<ConsentDirective> getActiveConsentDirectives(
        final Collection<String> patientIens) {
        return this.pip.getActiveConsentDirectives(patientIens);
    }

    @Override
    public Collection<FunctionalRole> getAllowedFunctionalRoles() {
        return this.pip.getAllowedFunctionalRoles();
    }

    @Override
    public Collection<Organization> getAllowedOrganizations() {
        return this.pip.getAllowedOrganizations();
    }

    @Override
    public Boolean getIsOrganizationTrustedSource(String organizationId) {
        return this.pip.getIsOrganizationTrustedSource(organizationId);
    }

    @Override
    public Collection<PurposeOfUse> getAllowedPurposeOfUse() {
        return this.pip.getAllowedPurposeOfUse();
    }

    @Override
    public Collection<Facility> getAllowedVistAFacilities() {
        return this.pip.getAllowedVistAFacilities();
    }

    @Override
    public String getAuthorityName(final String oid) {
        return this.pip.getAuthorityName(oid);
    }

    @Override
    public PatientDocument getConsentDirectiveDocumentByType(
        final ConsentDirective consentDirective,
        final PatientDocumentType patientDocumentType) {
        return this.pip.getConsentDirectiveDocumentByType(consentDirective,
            patientDocumentType);
    }

    @Override
    public Collection<PatientDocument> getConsentDirectiveDocuments(
        final ConsentDirective consentDirective) {
        return this.pip.getConsentDirectiveDocuments(consentDirective);
    }

    @Override
    public Collection<ConsentDirective> getConsentHistory(
        final Collection<String> patientIen) {
        return this.pip.getConsentHistory(patientIen);
    }

    @Override
    public ConsentType getConsentTypeByName(final String name) {
        return this.pip.getConsentTypeByName(name);
    }

    @Override
    public Facility getFacilityByStationId(final String stationId) {
        return (this.pip.getFacilityByStationId(stationId));
    }

    @Override
    public Location getLocationByCode(final String locationCode) {
        return this.pip.getLocationByCode(locationCode);
    }

    @Override
    public Collection<OptoutReason> getOptoutReasons() {
        return this.pip.getOptoutReasons();
    }

    @Override
    public Organization getOrganizationById(final Long id) {
        return this.pip.getOrganizationById(id);
    }

    @Override
    public Organization getOrganizationByOid(final String oid) {
        return this.pip.getOrganizationByOid(oid);
    }

    @Override
    public Collection<PatientDocumentType> getPatientDocumentTypes() {
        return this.pip.getPatientDocumentTypes();
    }

    @Override
    public PolicyConstraints getPolicyConstraints(
        final Collection<String> patientIens, final ConsentType consentType) {
        return this.pip.getPolicyConstraints(patientIens, consentType);
    }

    @Required
    public void setPip(final PIPInterface pip) {
        this.pip = pip;
    }

    @Override
    public void storeConsentDirective(final ConsentDirective consentDirective) {
        this.pip.storeConsentDirective(consentDirective);
    }

    @Override
    public void storeOrganization(final Organization organization) {
        this.pip.storeOrganization(organization);
    }

    @Override
    public void storePatientDocument(final PatientDocument patientDocument) {
        this.pip.storePatientDocument(patientDocument);
    }

    @Override
    public void updatePatientDocument(final PatientDocument patientDocument) {
        this.pip.updatePatientDocument(patientDocument);
    }

    @Override
    public Collection<ConsentDirective> getExpiringPatientConsentDirectives(
        Collection<String> patientIens, ConsentDirectiveDetailedExpirationRequest consentDirectiveExpirationRequest) {
        return pip.getExpiringPatientConsentDirectives(patientIens, consentDirectiveExpirationRequest);
    }

    @Override
    public PurposeOfUse getPurposeOfUseByValue(String name) {
        return this.pip.getPurposeOfUseByValue(name);
    }

    @Override
    public Collection<Organization> getAllowedNonConsumerOnlyOrganizations() {
        return this.getAllowedNonConsumerOnlyOrganizations();
    }

    @Override
    public Collection<Organization> getAllowedConsumerOnlyOrganizations() {
        return this.getAllowedConsumerOnlyOrganizations();
    }

    @Override
    public ExpiringConsentConfiguration getExpiringConsentConfiguration() {
        return this.pip.getExpiringConsentConfiguration();
    }

    @Override
    public void updateExpiringConsentConfiguration(
        ExpiringConsentConfiguration config) {
        this.pip.updateExpiringConsentConfiguration(config);
    }

    @Override
    public Collection<DetailedConsentDirective> getExpiringPatientDetailedConsentDirectives(ConsentDirectiveDetailedExpirationRequest consentDirectiveExpirationRequest) {
        return pip.getExpiringPatientDetailedConsentDirectives(consentDirectiveExpirationRequest);
    }

    @Override
    public Collection<FacilityOptInConsent> getAuthorizedConsentForSummary() {
        return pip.getAuthorizedConsentForSummary();
    }

    @Override
    public Collection<AnnouncementOrg> getAllAnnouncementOrgs() {
        return pip.getAllAnnouncementOrgs();
    }

    @Override
    public Collection<AnnouncementOrg> getAnnouncementOrgsByAnnouncement(Announcement announcement) {
        return pip.getAnnouncementOrgsByAnnouncement(announcement);
    }

    @Override
    public void storeAnnouncementOrg(AnnouncementOrg announceOrg) {
        this.pip.storeAnnouncementOrg(announceOrg);
    }

    @Override
    public void updateAnnouncementOrg(AnnouncementOrg announceOrg) {
        this.pip.updateAnnouncementOrg(announceOrg);
    }

    @Override
    public Collection<ConsentDirective> getRecentlyExpiredConsent() {
        return this.pip.getRecentlyExpiredConsent();
    }

    @Override
    public ConsentDirective getConsentDirective(Long id) {
        return this.pip.getConsentDirective(id);
    }

    @Override
    public Facility getFacilityByName(String facilityName) {
        return this.pip.getFacilityByName(facilityName);
    }

}
