package gov.va.nvap.server.endpoint.pip;

import gov.va.nvap.svc.consentmgmt.stub.FacilityResolver;

import javax.ejb.Stateless;
import javax.interceptor.Interceptors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.ejb.interceptor.SpringBeanAutowiringInterceptor;

/**
 * Resolve Patient's Preferred Facility by calling the ESR webservice.
 * 
 * @author Asha Amritraj
 * 
 */
@Stateless(name = "FacilityResolver", mappedName = "FacilityResolver")
@javax.ejb.Remote(FacilityResolver.class)
@Interceptors(SpringBeanAutowiringInterceptor.class)
public class FacilityResolverFacade implements FacilityResolver {

	@Autowired
	@Qualifier(value = "FacilityResolver")
	FacilityResolver facilityResolver;

	@Override
	public String getPatientPreferredFacility(final String patientIcn) {
		return this.facilityResolver.getPatientPreferredFacility(patientIcn);
	}

	@Override
	public String getUserFacility(final String userId) {
		return this.facilityResolver.getUserFacility(userId);
	}

}
