package gov.va.nvap.server.endpoint.pip;

import gov.va.nvap.service.privacy.ConsentManagementService;

import javax.annotation.Resource;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.EJB;
import javax.ejb.MessageDriven;
import javax.ejb.MessageDrivenContext;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import javax.jms.Message;
import javax.jms.MessageListener;

/**
 * The consumer for the queue where the consent directive requests are received
 * asynchronously. This is mostly used if eBenefits likes to batch announce
 * patients to VAP.
 * 
 * @author Asha Amritraj
 */
@MessageDriven(mappedName = "jms.vap.ConsentDirectiveRequestQueue", activationConfig = {
		@ActivationConfigProperty(propertyName = "acknowledgeMode", propertyValue = "Auto-acknowledge"),
		@ActivationConfigProperty(propertyName = "destinationType", propertyValue = "javax.jms.Queue"),
		@ActivationConfigProperty(propertyName = "subscriptionDurability", propertyValue = "Durable"),
		@ActivationConfigProperty(propertyName = "clientId", propertyValue = "PatientAnnouncerMessageConsumer"),
		@ActivationConfigProperty(propertyName = "subscriptionName", propertyValue = "PatientAnnouncerMessageConsumer") })
@TransactionManagement(value = TransactionManagementType.BEAN)
public class ConsentDirectiveMessageConsumer implements MessageListener {

	@EJB(name = "ConsentManagementService", mappedName = "ConsentManagementService")
	ConsentManagementService cms;

	public ConsentDirectiveMessageConsumer() {
	}

	@Override
	public void onMessage(final Message message) {
		// TODO: Implement asynchronous processing of authorize/revoke
		throw new UnsupportedOperationException();
	}

	@Resource
	public void setContext(final MessageDrivenContext context) {
	}

}
