package gov.va.nvap.server.endpoint.permission.sls;

import gov.va.nvap.server.service.permission.sls.SecurityLabelingService;
import java.io.IOException;
import java.net.URL;

import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Service;
import javax.xml.ws.soap.MTOMFeature;

import org.slf4j.LoggerFactory;


/**
 *
 * @author john.crooks
 * 
 * Connects to SOAP Service provided by the SLS for the labeling of
 * a patients concatenated C-CDA CCD file. This service returns XML 
 * containing the patients high-water mark confidentiality code.
 */
public class SLSClient
{
    private static final String WSDL_RSRC =
        "/META-INF/xml-resources/web-services/SecurityLabelingService/SecurityLabelingService.wsdl";
    private static final QName SLS_QNAME = new QName(
        "http://sls.permission.service.server.nvap.va.gov/", "SecurityLabelingService");

    //****
    // Properties that should be set by Spring configuration.
    //****
    private String endPointURL;
    private static final org.slf4j.Logger LOGGER =
        LoggerFactory.getLogger(SLSClient.class);
    
    public String evalConfidentialityCode(byte[] patientXML) throws IOException
    {
        URL wsdlURL = SLSClient.class.getResource(WSDL_RSRC);

        // create the service
        Service service = Service.create(wsdlURL, SLS_QNAME);
        SecurityLabelingService sls = service.getPort(SecurityLabelingService.class, new MTOMFeature());

        //get the binding and enable MTOM
        BindingProvider bindingProvider = (BindingProvider) sls;
        bindingProvider.getRequestContext().put(BindingProvider.ENDPOINT_ADDRESS_PROPERTY, endPointURL);
        
        // hit the SLS
        String patientReturnData = sls.evalConfidentialityCode(patientXML);
        
        //Log the Data Coming back from SLS 
        if(patientReturnData!=null)
        {
            LOGGER.debug("Security Labeling Service was called succesfully and returned: " + patientReturnData);
        } 
        else 
        {
            LOGGER.debug("Null Value Returned from Security Labeling Service");
        }
        
        return patientReturnData; 
    } 

    public void setEndPointURL(String s)
    {
        endPointURL = s;
    }
}
