package gov.va.nvap.server.endpoint.permission.pdp;

import javax.xml.bind.JAXBElement;

import oasis.names.tc.xacml._2_0.context.schema.os.ObjectFactory;
import oasis.names.tc.xacml._2_0.context.schema.os.RequestType;
import oasis.names.tc.xacml._2_0.context.schema.os.ResponseType;

import org.springframework.ws.WebServiceMessageFactory;
import org.springframework.ws.client.core.WebServiceTemplate;

// based on http://springwstemplatejax2bxmlrootmissing.blogspot.com/
public class XACMLWebServiceTemplate extends WebServiceTemplate {

	/**
	 * Creates a new <code>WebServiceTemplate</code> based on the given message
	 * factory.
	 * 
	 * @param messageFactory
	 *            the message factory to use
	 */
	public XACMLWebServiceTemplate(final WebServiceMessageFactory messageFactory) {
		super(messageFactory);
	}

	@Override
	public ResponseType marshalSendAndReceive(final Object requestPayload) {
		ResponseType response = null;

		// type cast the object to the specific request object. Using generics
		// helps to use it for all the generated JAXB objects
		final RequestType request = (RequestType) requestPayload;
		/*
		 * try { String fieldName = "_Request_QNAME";
		 * 
		 * // lookup the private QNAME object for the request object declared //
		 * in the generated ObjectFactory Field field =
		 * ObjectFactory.class.getDeclaredField(fieldName);
		 * field.setAccessible(true); if (field.getName().equals(fieldName)) {
		 * // create the JAXB Element for the given class Field requestField =
		 * this.getClass().getDeclaredField( "requestType"); // get the class
		 * type of generic JAXB input object Class requestClass =
		 * requestField.getDeclaringClass(); JAXBElement<RequestType>
		 * jaxbElement = new JAXBElement<RequestType>( (QName) field.get(null),
		 * requestClass, null, request); // invoke the super class method with
		 * the JAXBElement and type // cast the response JAXBElement to the
		 * generic response type // object. JAXBElement<ResponseType>
		 * responseObject = (JAXBElement<ResponseType>) super
		 * .marshalSendAndReceive(jaxbElement); if (responseObject != null) {
		 * response = responseObject.getValue(); } } } catch (Exception
		 * exception) { exception.printStackTrace(); }
		 * 
		 * JAXBElement<RequestType> jaxbElement = new JAXBElement<RequestType>(
		 * new QName("urn:oasis:names:tc:xacml:2.0:context:schema:os",
		 * "Request"), (Class<RequestType>) request.getClass(), request);
		 */
		final JAXBElement<RequestType> jaxbElement = new ObjectFactory()
				.createRequest(request);
		// invoke the super class method with the JAXBElement and type
		// cast the response JAXBElement to the generic response type
		// object.
		final JAXBElement<ResponseType> responseObject = (JAXBElement<ResponseType>) super
				.marshalSendAndReceive(jaxbElement);
		if (responseObject != null) {
			response = responseObject.getValue();
		}

		return response;
	}
}
