package gov.va.nvap.server.endpoint.pdq;

import gov.va.nvap.service.pdq.PatientCorrelationsQuery;
import gov.va.nvap.service.pdq.PatientCorrelationsResponse;
import gov.va.nvap.service.pdq.PatientDemographicsQuery;
import gov.va.nvap.service.pdq.PatientDemographicsResponse;
import gov.va.nvap.service.pdq.PatientMatchQuery;
import gov.va.nvap.service.pdq.PatientMatchResponse;
import gov.va.nvap.service.pdq.PdqException;
import gov.va.nvap.service.pdq.PdqService;
import gov.va.nvap.service.pdq.RemovePatientCorrelationRequest;
import javax.ejb.Stateless;
import javax.interceptor.Interceptors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.ejb.interceptor.SpringBeanAutowiringInterceptor;

/**
 * The stateless EJB for the authorization preference service.
 * 
 * @author Asha Amritraj
 */
@Stateless(name = "PdqService", mappedName = "PdqService")
@javax.ejb.Remote(PdqService.class)
@Interceptors(SpringBeanAutowiringInterceptor.class)
public class PdqServiceFacade implements PdqService {

	@Autowired
	@Qualifier(value = "PdqService")
	PdqService pdqService;

	@Override
	public PatientCorrelationsResponse getCorrelatedFacilities(
			final PatientCorrelationsQuery query) throws PdqException {
		return this.pdqService.getCorrelatedFacilities(query);
	}

	@Override
	public PatientDemographicsResponse getPatientDemographics(
			final PatientDemographicsQuery query) throws PdqException {
		return this.pdqService.getPatientDemographics(query);
	}

	@Override
	public RemovePatientCorrelationRequest removePatientCorrelation(
			final RemovePatientCorrelationRequest request) throws PdqException {
		return this.pdqService.removePatientCorrelation(request);
	}

	@Override
	public PatientMatchResponse searchPatient(
			final PatientMatchQuery patientMatchRequest) throws PdqException {
		return this.pdqService.searchPatient(patientMatchRequest);
	}

}
