package gov.va.nvap.server.endpoint.mpi.transceiver;

/**
 * Handles the send and recieve from the MPI.
 * 
 * @author Asha Amritraj
 * 
 */
public class HL7MLLPTransceiver extends
		gov.va.nvap.common.transceiver.client.SocketTransceiver {

	static public final String FSCR = "\u001C\r";
	static public final String VT = "\u000B";

	@Override
	protected String formatIncomingMessage(final String payload) {
		String ret;
		if (payload.startsWith(HL7MLLPTransceiver.VT)
				&& payload.endsWith(HL7MLLPTransceiver.FSCR)) {
			ret = payload.substring(1, payload.length() - 2);
		} else {
			ret = payload;
		}
		return ret;
	}

	@Override
	protected String formatOutgoingMessage(final String payload) {
		// MPI requires these to parse the messages.
		return HL7MLLPTransceiver.VT + payload + HL7MLLPTransceiver.FSCR;
	}

	@Override
	protected String getEndMarker() {
		return HL7MLLPTransceiver.FSCR;
	}

	@Override
	protected int getEndMarkerPosition() {
		return 0;
	}

}
