package gov.va.nvap.server.endpoint.mpi;

import gov.va.nvap.common.endpoint.Endpoint;
import gov.va.nvap.common.endpoint.EndpointException;
import gov.va.nvap.common.transceiver.client.Transceiver;
import gov.va.nvap.common.transformer.TransformerException;
import gov.va.nvap.common.transformer.hl7.ER7ToXML;
import gov.va.nvap.common.transformer.xsl.XMLtoString;

import org.springframework.beans.factory.annotation.Required;
import org.w3c.dom.Document;

/**
 * Manages all the communication with the MPI.
 * 
 * @author Asha Amritraj
 */
public class MviSocketEndpoint implements Endpoint<Document, Document> {

	private ER7ToXML er7ToXmlTransformer;
	private Transceiver<String> socketTransceiver;
	private XMLtoString xmlToEr7Transformer;

	@Override
	public Document invoke(final Document xmlQuery) throws EndpointException {

		try {
			final String er7Query = this.xmlToEr7Transformer
					.transform(xmlQuery);
			final String er7Response = this.socketTransceiver
					.transceive(er7Query);
			final Document xmlResponse = this.er7ToXmlTransformer
					.transform(er7Response);
			return xmlResponse;
		} catch (final TransformerException ex) {
			throw new EndpointException(ex);
		}
	}

	@Required
	public void setEr7ToXmlTransformer(final ER7ToXML er7ToXmlTransformer) {
		this.er7ToXmlTransformer = er7ToXmlTransformer;
	}

	@Required
	public void setSocketTransceiver(final Transceiver<String> socketTransceiver) {
		this.socketTransceiver = socketTransceiver;
	}

	@Required
	public void setXmlToEr7Transformer(final XMLtoString xmlToEr7Transformer) {
		this.xmlToEr7Transformer = xmlToEr7Transformer;
	}

}
