/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.nvap.server.endpoint.esr;

import gov.va.med.esr.webservices.jaxws.schemas.GetEESummaryRequest;
import gov.va.med.esr.webservices.jaxws.schemas.GetEESummaryResponse;
import gov.va.nvap.service.esr.EnrollmentService;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.QName;

import org.springframework.ws.client.core.WebServiceTemplate;

/**
 * Enrollment Service Endpoint (Proxy/Client)
 * 
 * @author Anand Sastry
 */
public class EnrollmentServiceEndpoint implements EnrollmentService {

	private static final Logger logger = Logger
			.getLogger(EnrollmentService.class.getName());
	private WebServiceTemplate esrServiceTemplate;

	private void dumpRequestContents(final String context,
			final GetEESummaryRequest req) {
		if (EnrollmentServiceEndpoint.logger.isLoggable(Level.INFO)) {
			final StringWriter sw = new StringWriter();
			// FileWriter fw = new FileWriter();
			this.foo(context, req, sw);
			EnrollmentServiceEndpoint.logger.logp(Level.INFO,
					"GetEESummaryRequest", context, sw.getBuffer().toString());
			try {
				sw.close();
			} catch (final IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
	}

	private void dumpResponseContents(final String context,
			final GetEESummaryResponse res) {
		if (EnrollmentServiceEndpoint.logger.isLoggable(Level.INFO)) {
			final StringWriter sw = new StringWriter();
			// FileWriter fw = new FileWriter();
			this.foo(context, res, sw);
			EnrollmentServiceEndpoint.logger.logp(Level.INFO,
					"GetEESummaryResponse", context, sw.getBuffer().toString());
			try {
				sw.close();
			} catch (final IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
	}

	private void foo(final String context, final Object obj, final Writer writer) {
		try {
			if (obj == null) {
				return;
			}
			final JAXBContext jaxbContext = JAXBContext.newInstance(obj
					.getClass());
			final Marshaller m = jaxbContext.createMarshaller();
			m.setProperty(Marshaller.JAXB_FORMATTED_OUTPUT, true);

			// m.marshal(req, System.out);
			m.marshal(new JAXBElement(new QName("uri", "local"),
					obj.getClass(), obj), writer);
		} catch (final JAXBException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

	@Override
	public GetEESummaryResponse getEESummaryRequest(
			final GetEESummaryRequest request) {
		if (EnrollmentServiceEndpoint.logger.isLoggable(Level.INFO)) {
			EnrollmentServiceEndpoint.logger.logp(Level.INFO,
					"EnrollmentServiceEndpoint",
					"getEESummaryRequest Before invocation", "URI: "
							+ this.esrServiceTemplate.getDefaultUri());
		}

		this.dumpRequestContents("getEESummaryRequest Before invocation",
				request);
		GetEESummaryResponse response = null;
		final Object retVal = this.esrServiceTemplate
				.marshalSendAndReceive(request);
		if (EnrollmentServiceEndpoint.logger.isLoggable(Level.INFO)) {
			EnrollmentServiceEndpoint.logger.logp(Level.INFO,
					"EnrollmentServiceEndpoint",
					"getEESummaryRequest After invocation", "response class: "
							+ retVal.getClass());
		}
		if (retVal instanceof GetEESummaryResponse) {
			response = (GetEESummaryResponse) retVal;
		} else {
			final JAXBElement jaxbRetVal = (JAXBElement) retVal;
			response = (GetEESummaryResponse) jaxbRetVal.getValue();
		}
		this.dumpResponseContents("getEESummaryRequest After invocation",
				response);
		return response;
	}

	public void setEsrServiceTemplate(
			final WebServiceTemplate esrServiceTemplate) {
		this.esrServiceTemplate = esrServiceTemplate;
	}
}
