package gov.va.nvap.server.endpoint.audit;

import gov.va.nvap.privacy.ConsentType;
import gov.va.nvap.service.audit.AuditException;
import gov.va.nvap.service.audit.AuditService;
import gov.va.nvap.service.audit.data.ConsentAudit;
import gov.va.nvap.service.audit.data.UserAccessAudit;

import javax.ejb.Stateless;
import javax.interceptor.Interceptors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.ejb.interceptor.SpringBeanAutowiringInterceptor;

@Stateless(name = "AuditService", mappedName = "AuditService")
@javax.ejb.Remote(AuditService.class)
@Interceptors(SpringBeanAutowiringInterceptor.class)
public class AuditServiceFacade implements AuditService {

	@Autowired
	@Qualifier(value = "gov.va.nvap.server.service.audit.AuditService")
	AuditService auditService;

	@Override
	public void auditConsent(final ConsentAudit consentAudit)
			throws AuditException {
		this.auditService.auditConsent(consentAudit);

	}

	@Override
	public void auditUserAccess(final UserAccessAudit userAccessAudit)
			throws AuditException {
		this.auditService.auditUserAccess(userAccessAudit);
	}

    @Override
    public ConsentAudit getLatestAudit(String patientID, String consentType) {
        return this.auditService.getLatestAudit(patientID, consentType);
    }

}
