/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.nvap.server.endpoint.announce;

import gov.va.nvap.svc.consentmgmt.stub.adapter.announce.data.Announcement;
import gov.va.nvap.svc.consentmgmt.stub.adapter.announce.data.AnnouncementBatchSummary;
import gov.va.nvap.svc.consentmgmt.stub.adapter.announce.data.AnnouncementOrg;
import gov.va.nvap.svc.consentmgmt.stub.adapter.announce.data.AnnouncerInterface;
import gov.va.nvap.svc.consentmgmt.stub.data.Organization;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.interceptor.Interceptors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.ejb.interceptor.SpringBeanAutowiringInterceptor;

/**
 * 
 * @author vhaislegberb
 * @author Irakli Kakushadze
 * @author Zack Peterson
 */
@Stateless(name = "AnnouncerService", mappedName = "AnnouncerService")
@Remote(AnnouncerInterface.class)
@Interceptors(SpringBeanAutowiringInterceptor.class)
public class AnnouncerFacade implements AnnouncerInterface {

	/**
	 * Spring injection, so that all the dependencies are injected.
	 */
	@Autowired
	@Qualifier(value = "Announcer")
	AnnouncerInterface announcer;

	@Override
	public String createAnnouncementsBatch(
			final Organization targetedOrganization, final String userId,
			final Date dateRangeStart, final Date dateRangeStop,
			final boolean reannounce) {
		return this.announcer.createAnnouncementsBatch(targetedOrganization,
				userId, dateRangeStart, dateRangeStop, reannounce);
	}

 	@Override
    public String createAnnouncementsBatch(
			final Organization targetedOrganization, final String userId, HashSet<String> iens) {
		return this.announcer.createAnnouncementsBatch(targetedOrganization, userId, iens);
	}
    
    @Override
    public String createAnnouncementsBatch(Collection<Organization> targetedOrganizations,
			String userId, Date dateRangeStart, Date dateRangeStop,
			boolean reannounce){
        return this.announcer.createAnnouncementsBatch(targetedOrganizations,
				userId, dateRangeStart, dateRangeStop, reannounce);
    }

    @Override
    public String createAnnouncementsBatch(Collection<Organization> targetedOrganizations,
			String userId, HashSet<String> iens) {
        return this.announcer.createAnnouncementsBatch(targetedOrganizations, userId, iens);
    }

	@Override
	public Announcement getAnnouncementById(final Long announcementId) {
		return this.announcer.getAnnouncementById(announcementId);
	}

    /**
     * Finds all announcements for a particular user.
     * 
     * @param userId User ID
     * @return List of objects of type Announcement found for this user
     */
    @Override
    public List<Announcement> getAnnouncementsByUserId(String userId) {
        return this.announcer.getAnnouncementsByUserId(userId);
    }
    
    /**
     * Finds all announcements for a list of consent directive ID numbers
     * 
     * @param consentDirectiveIds list of consent directive ID numbers
     * @return List of objects of type Announcement found for this patient
     */
    @Override
    public List<Announcement> getAnnouncementsByConsentDirectiveId(List<Long> consentDirectiveIds) {
        return this.announcer.getAnnouncementsByConsentDirectiveId(consentDirectiveIds);
    }
    
	@Override
	public List<AnnouncementBatchSummary> getBatchSummary(
			final List<String> batchIds) {
		return this.announcer.getBatchSummary(batchIds);
	}

	@Override
	public List<AnnouncementBatchSummary> getBatchSummaryByDateRange(
			final Date startDate, final Date endDate) {
		return this.announcer.getBatchSummaryByDateRange(startDate, endDate);
	}

	@Override
	public Collection<Announcement> getUnscheduledAnnouncementsByBatchId(
			final String batchId, final int maxAnnouncements, final int firstResult) {
		return this.announcer.getUnscheduledAnnouncementsByBatchId(batchId,
				maxAnnouncements, firstResult);
	}

	@Override
	public void removeAnnouncementBatches(final Collection<String> batchIds) {
		this.announcer.removeAnnouncementBatches(batchIds);
	}

	@Override
	public List<AnnouncementBatchSummary> retrieveBatchSummaries(
			final Date startDate, final Date endDate, final String orgOid,
			final String userId, final int firstResult, final int maxResults) {
		return this.announcer.retrieveBatchSummaries(startDate, endDate,
				orgOid, userId, firstResult, maxResults);
	}

	@Override
	public void storeAnnouncement(final Announcement announcement) {
		this.announcer.storeAnnouncement(announcement);
	}
    
    @Override
    public void createAnnouncementOrg(AnnouncementOrg announceOrg) {
        this.announcer.createAnnouncementOrg(announceOrg);
    }
    
    @Override
    public List<Announcement> getNonBatchAnnouncementsByCreatedTs(Date createdTs, String patientIen) {
        return this.announcer.getNonBatchAnnouncementsByCreatedTs(createdTs, patientIen);
    }
    
    @Override
    public int getAnnounceExclusionTimeframeHours() {
        return this.announcer.getAnnounceExclusionTimeframeHours();
	}
    
    @Override
    public List<AnnouncementOrg> getAnnouncementOrgsByAnnouncement(Announcement announcement) {
        return this.announcer.getAnnouncementOrgsByAnnouncement(announcement);
	}
    
    @Override
    public void removeByAnnouncement(Announcement announcement) {
        this.announcer.removeByAnnouncement(announcement);
	}
    
    @Override
    public HashMap getAnnouncementsByBatchIdWithPaging(String batchId, String orgId, Integer startRow, Integer maxRows) {
        return this.announcer.getAnnouncementsByBatchIdWithPaging(batchId, orgId, startRow, maxRows);
    }
}
