package gov.va.nvap.server.endpoint.adapter.doc;

import gov.va.nvap.common.validation.Assert;
import gov.va.nvap.common.validation.NullChecker;
import gov.va.nvap.service.adapter.doc.AdapterDocQueryRetrieve;
import gov.va.nvap.service.adapter.doc.AdapterException;

import java.util.Date;
import java.util.List;
import java.util.Map;

import javax.ejb.Stateless;
import javax.interceptor.Interceptors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.ejb.interceptor.SpringBeanAutowiringInterceptor;

/**
 * Facade for the adapter doc query/retrieve.
 * 
 * @author Asha Amritraj
 */
@Stateless(name = "AdapterDocQueryRetrieve", mappedName = "AdapterDocQueryRetrieve")
@javax.ejb.Remote(AdapterDocQueryRetrieve.class)
@Interceptors(SpringBeanAutowiringInterceptor.class)
public class AdapterDocQueryRetrieveFacade implements AdapterDocQueryRetrieve {
    public static final String DQ_MAP_HOME_COMMUNITY_ID = "homeCommunityId";
    public static final String DQ_MAP_DOCUMENT_REPOSITORY_ID = "documentRepositoryId";
    public static final String DQ_MAP_DOCUMENT_UNIQUE_ID = "documentUniqueId";

	@Autowired
	@Qualifier(value = "adapterDocQueryEndpoint")
	AdapterDocQueryEndpoint adapterDocQueryEndpoint;

	@Autowired
	@Qualifier(value = "adapterDocRetrieveEndpoint")
	AdapterDocRetrieveEndpoint adapterDocRetrieveEndpoint;

	@Override
	public String getDocument(final String patientId, final Date startDate,
			final Date endDate, final String userName) throws AdapterException {
		Assert.assertNotEmpty(patientId, "Patient id cannot be null!");

		final List<Map<String, String>> documents = this.getDocuments(
				patientId, startDate, endDate, userName);

		if (NullChecker.isNotEmpty(documents)) {
			final Map<String, String> docMap = documents.get(0);
			final String document = this.getDocument(patientId,
					docMap.get(DQ_MAP_DOCUMENT_UNIQUE_ID),
					docMap.get(DQ_MAP_DOCUMENT_REPOSITORY_ID),
					docMap.get(DQ_MAP_HOME_COMMUNITY_ID), userName);
			return document;
		}
		return null;
	}

	@Override
	public String getDocument(final String icn, final String documentUniqueId,
			final String documentRepositoryId, final String homeCommunityId,
			final String userName) throws AdapterException {
		Assert.assertNotEmpty(userName, "User cannot be null!");

		return this.adapterDocRetrieveEndpoint.getDocument(icn,
				documentUniqueId, documentRepositoryId, homeCommunityId,
				userName);
	}

	@Override
	public List<Map<String, String>> getDocuments(final String patientId,
			final Date fromDate, final Date toDate, final String userName)
			throws AdapterException {
		Assert.assertNotEmpty(patientId, "Patient id cannot be null!");

		return this.adapterDocQueryEndpoint.getDocuments(patientId, fromDate,
				toDate);
	}
}
