package gov.va.nvap.server.endpoint.adapter.audit;

import gov.va.med.nhin.adapter.audit.GetAudits;
import gov.va.med.nhin.adapter.audit.GetAuditsResponse;
import gov.va.med.nhin.adapter.audit.GetAuditsSummary;
import gov.va.med.nhin.adapter.audit.GetAuditsSummaryResponse;
import gov.va.med.nhin.adapter.audit.PageInfoType;
import gov.va.nvap.service.adapter.audit.AdapterAuditManager;
import gov.va.nvap.service.audit.AuditException;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.ws.client.core.WebServiceTemplate;

/**
 * The spring-ws template to call the adapter's webservice.
 * 
 * @author Asha Amritraj
 */
public class AuditServiceEndpoint implements AdapterAuditManager {

	/**
	 * Audit web service template to talk to the adpater's webservice.
	 */
	private WebServiceTemplate auditServiceTemplate;

	@Override
    public GetAuditsResponse getAudits(final GetAudits getAuditsRequest) throws AuditException {
        try {
            final GetAuditsResponse response = (GetAuditsResponse) this.auditServiceTemplate.marshalSendAndReceive(getAuditsRequest);
            return response;
        } catch (Exception e) {
            throw new AuditException();
        }
    }
    
	@Override
	public GetAuditsSummaryResponse getAuditSummary(
            final GetAuditsSummary auditSummaryQueryRequest)
            throws AuditException {
		try {
            final GetAuditsSummaryResponse response = (GetAuditsSummaryResponse) this.auditServiceTemplate
                    .marshalSendAndReceive(auditSummaryQueryRequest);
            return response;
        } catch(Exception e) {
            throw new AuditException();
        }
	}

	/**
	 * @param auditServiceTemplate
	 *            the auditServiceTemplate to set
	 */
	@Required
	public void setAuditServiceTemplate(
			final WebServiceTemplate auditServiceTemplate) {
		this.auditServiceTemplate = auditServiceTemplate;
	}
}