package gov.va.nvap.server.endpoint.adapter.audit;

import gov.va.med.nhin.adapter.audit.GetAudits;
import gov.va.med.nhin.adapter.audit.GetAuditsResponse;
import gov.va.med.nhin.adapter.audit.GetAuditsSummary;
import gov.va.med.nhin.adapter.audit.GetAuditsSummaryResponse;
import gov.va.nvap.service.adapter.audit.AdapterAuditManager;
import gov.va.nvap.service.audit.AuditException;

import javax.ejb.Stateless;
import javax.interceptor.Interceptors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.ejb.interceptor.SpringBeanAutowiringInterceptor;

/**
 * The stateless session bean which serves as a facade to get to the NwHIN
 * adapter's webservice.
 * 
 * @author Asha Amritraj
 */
@Stateless(name = "AdapterAuditManager", mappedName = "AdapterAuditManager")
@javax.ejb.Remote(AdapterAuditManager.class)
@Interceptors(SpringBeanAutowiringInterceptor.class)
public class AdapterAuditServiceFacade implements AdapterAuditManager {
	@Autowired
	@Qualifier(value = "auditServiceEndpoint")
	AuditServiceEndpoint auditServiceEndpoint;

	@Override
	public GetAuditsResponse getAudits(final GetAudits getAuditsRequest)
			throws AuditException {
		return this.auditServiceEndpoint.getAudits(getAuditsRequest);
	}

	@Override
	public GetAuditsSummaryResponse getAuditSummary(
			final GetAuditsSummary auditSummaryQueryRequest)
			throws AuditException {
		return this.auditServiceEndpoint
				.getAuditSummary(auditSummaryQueryRequest);
	}
}