package gov.va.nvap.server.endpoint.adapter.announce.interceptor;

import gov.va.nvap.common.transformer.Transformer;
import gov.va.nvap.common.transformer.TransformerException;
import gov.va.nvap.common.validation.Assert;
import gov.va.nvap.common.validation.NullChecker;
import gov.va.nvap.privacy.ConsentType;
import gov.va.nvap.service.audit.ConsentAuditType;
import gov.va.nvap.service.audit.data.ConsentAudit;
import gov.va.nvap.svc.consentmgmt.stub.adapter.announce.jaxb.AnnouncePatientRequest;

import java.util.Date;

/**
 * A transformer for converting the Announce patient type to the audit object.
 *
 * @author Asha Amritraj
 */
public class AnnounceToConsentAudit implements
		Transformer<Object, ConsentAudit> {

	@Override
	public ConsentAudit transform(final Object object)
			throws TransformerException {

		String icn = null;
		String userId = null;
		String facilityId = null;
		String firstName = null;
		String middleName = null;
		String lastName = null;
		String ssn = null;
		// We use 2 types, one for sync. and async.
		if (AnnouncePatientRequest.class.isInstance(object)) {
			final AnnouncePatientRequest type = (AnnouncePatientRequest) object;
			icn = type.getPatient().getPatientId();
			if (NullChecker.isNotEmpty(type.getUser())) {
				// Only user id is present at this time
				userId = type.getUser().getUserId();
				facilityId = type.getUser().getFacilityNumber();
			}
			firstName = type.getPatient().getLastName();
			middleName = type.getPatient().getMiddleName();
			lastName = type.getPatient().getGivenName();
			ssn = type.getPatient().getSsn();

		} else {
			throw new TransformerException(
					"Unknown type when transforming PatientAnnouncer messages!");
		}

		Assert.assertNotEmpty(icn, "Patient Id is required!");
		Assert.assertNotEmpty(userId, "User Id is required!");
		// Create the audit object
		final ConsentAudit consentAudit = new ConsentAudit();
		consentAudit
				.setActionType(ConsentAuditType.ANNOUNCE_AUDIT_TYPE.value());
		consentAudit.setCreatedDate(new Date());
		consentAudit.setPatientId(icn);
		consentAudit.setTimeOfEvent(new Date());
		consentAudit.setUserId(userId);
		consentAudit.setFacility(facilityId);
		// Store demographics
		consentAudit.setPatientLastName(lastName);
		consentAudit.setPatientMiddleName(middleName);
		consentAudit.setPatientGivenName(firstName);
		consentAudit.setPatientSsn(ssn);
		// Temporary Fix to always use NW_HIN as this is the only place where we
		// can remove correlations.
		// TODO: Pass a service consumer context type as part of the request.
		consentAudit.setConsentType(ConsentType.NW_HIN_AUTHORIZATION.value());
		return consentAudit;
	}

}
