package gov.va.nvap.server.endpoint.adapter.announce;

import gov.va.nvap.common.jaxb.JaxbUtil;
import gov.va.nvap.common.transformer.TransformerException;
import gov.va.nvap.common.transformer.xml.StringToXML;
import gov.va.nvap.common.validation.Assert;
import gov.va.nvap.svc.consentmgmt.stub.adapter.announce.data.PatientAnnouncer;
import gov.va.nvap.svc.consentmgmt.stub.adapter.announce.data.PatientAnnouncerException;
import gov.va.nvap.svc.consentmgmt.stub.adapter.announce.jaxb.AnnouncePatientRequest;

import javax.annotation.Resource;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.EJB;
import javax.ejb.MessageDriven;
import javax.ejb.MessageDrivenContext;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.interceptor.Interceptors;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import javax.xml.bind.JAXBException;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.ejb.interceptor.SpringBeanAutowiringInterceptor;

/**
 * A message driven bean to consume messages from a queue.
 * 
 * @author Asha Amritraj
 * 
 */
@MessageDriven(mappedName = "jms.vap.PatientAnnouncerForwardingQueue", activationConfig = {
		@ActivationConfigProperty(propertyName = "acknowledgeMode", propertyValue = "Auto-acknowledge"),
		@ActivationConfigProperty(propertyName = "destinationType", propertyValue = "javax.jms.Queue"),
		@ActivationConfigProperty(propertyName = "subscriptionDurability", propertyValue = "Durable"),
		@ActivationConfigProperty(propertyName = "clientId", propertyValue = "PatientAnnouncerMessageConsumer"),
		@ActivationConfigProperty(propertyName = "subscriptionName", propertyValue = "PatientAnnouncerMessageConsumer") })
@TransactionAttribute(TransactionAttributeType.REQUIRES_NEW)
@Interceptors(SpringBeanAutowiringInterceptor.class)
public class PatientAnnouncerMessageConsumer implements MessageListener {

	/**
	 * The patient announcer EJB object.
	 */
	@EJB(name = "PatientAnnouncer", mappedName = "PatientAnnouncer")
	PatientAnnouncer patientAnnouncer;

	/**
	 * JAXB objects to convert from Document to AnnouncePatientRequest/Response.
	 */
	@Autowired
	@Qualifier(value = "PatientAnnouncerJaxbHelper")
	JaxbUtil patientAnnouncerJaxbHelper;

	public PatientAnnouncerMessageConsumer() {
	}

	@Override
	public void onMessage(final Message message) {
		// Only text message is supported
		if (TextMessage.class.isInstance(message)) {
			try {
				// Get the XML message as text
				final String text = ((TextMessage) message).getText();
				Assert.assertNotEmpty(text, "Announce message cannot be empty!");
				// Convert to JAXB Type
				final AnnouncePatientRequest request = (AnnouncePatientRequest) this.patientAnnouncerJaxbHelper
						.unmarshal(new StringToXML().transform(text));
				// Announce to EJB
				this.patientAnnouncer.announce(request);
			} catch (final JAXBException ex) {
				throw new RuntimeException(ex);
			} catch (final PatientAnnouncerException ex) {
				throw new RuntimeException(ex);
			} catch (final TransformerException ex) {
				throw new RuntimeException(ex);
			} catch (final JMSException ex) {
				throw new RuntimeException(ex);
			}
		} else {
			throw new UnsupportedOperationException();
		}
	}

	@Resource
	public void setContext(final MessageDrivenContext context) {
	}
}
