package gov.va.nvap.server.endpoint.adapter.announce;

import gov.va.nvap.svc.consentmgmt.stub.adapter.announce.data.Announcement;
import gov.va.nvap.svc.consentmgmt.stub.adapter.announce.data.PatientAnnouncer;
import gov.va.nvap.svc.consentmgmt.stub.adapter.announce.data.PatientAnnouncerException;
import gov.va.nvap.svc.consentmgmt.stub.adapter.announce.jaxb.AnnouncePatientRequest;
import gov.va.nvap.svc.consentmgmt.stub.adapter.announce.jaxb.AnnouncePatientResponse;
import java.util.List;

import javax.ejb.Stateless;
import javax.interceptor.Interceptors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.ejb.interceptor.SpringBeanAutowiringInterceptor;

/**
 * Announce Patient Facade.
 * 
 * @author Asha Amritraj
 * @author Irakli Kakushadze
 * @author Zack Peterson
 */
@Stateless(name = "PatientAnnouncer", mappedName = "PatientAnnouncer")
@javax.ejb.Remote(gov.va.nvap.svc.consentmgmt.stub.adapter.announce.data.PatientAnnouncer.class)
@Interceptors(SpringBeanAutowiringInterceptor.class)
public class PatientAnnouncerFacade implements PatientAnnouncer {

	@Autowired
	@Qualifier(value = "PatientAnnouncerEndpoint")
	PatientAnnouncerEndpoint patientAnnouncerEndpoint;

	@Override
	public AnnouncePatientResponse announce(
			final AnnouncePatientRequest announcePatientRequest)
			throws PatientAnnouncerException {
		return this.patientAnnouncerEndpoint.announce(announcePatientRequest);
	}

	@Override
	public void announceAsync(
			final AnnouncePatientRequest announcePatientRequest)
			throws PatientAnnouncerException {
		this.patientAnnouncerEndpoint.announceAsync(announcePatientRequest);
	}

    @Override
    public AnnouncePatientResponse announceAll(
            AnnouncePatientRequest announcePatientRequest)
            throws PatientAnnouncerException {
        return this.patientAnnouncerEndpoint.announceAll(announcePatientRequest);
    }

    /**
     * Finds all announcements for a particular user.
     * 
     * @param userId User ID
     * @return List of objects of type Announcement found for this user
     */
    @Override
    public List<Announcement> getAnnouncementsByUserId(String userId) {
        return this.patientAnnouncerEndpoint.getAnnouncementsByUserId(userId);
    }
    
    /**
     * Finds all announcements for a list of consent directive ID numbers
     * 
     * @param consentDirectiveIds List of Consent Directive ID numbers
     * @return List of objects of type Announcement found for this consent directive
     */
    @Override
    public List<Announcement> getAnnouncementsByConsentDirectiveId(List<Long> consentDirectiveIds) {
        return this.patientAnnouncerEndpoint.getAnnouncementsByConsentDirectiveId(consentDirectiveIds);
    }

}
