package gov.va.nvap.server.endpoint.adapter.announce;

import gov.va.nvap.common.jaxb.JaxbUtil;
import gov.va.nvap.svc.consentmgmt.stub.adapter.announce.jaxb.AnnouncePatientRequest;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.xml.bind.JAXBException;

import org.springframework.jms.core.MessageCreator;

/**
 * Create the Object message for the Spring JMS Template.
 * 
 * @author Asha Amritraj
 */
public class AnnouncePatientMessageCreator implements MessageCreator {

	AnnouncePatientRequest announcePatientRequest;
	JaxbUtil patientAnnouncerJaxbHelper;

	public AnnouncePatientMessageCreator(
			final AnnouncePatientRequest announcePatientRequest,
			final JaxbUtil patientAnnouncerJaxbHelper) {
		this.announcePatientRequest = announcePatientRequest;
		this.patientAnnouncerJaxbHelper = patientAnnouncerJaxbHelper;
	}

	@Override
	public Message createMessage(final Session session) throws JMSException {
		try {
			final String announcePatientRequestString = this.patientAnnouncerJaxbHelper
					.marshalString(this.announcePatientRequest);
			final TextMessage message = session
					.createTextMessage(announcePatientRequestString);
			return message;
		} catch (final JAXBException ex) {
			// JMS Exception only allows message
			throw new JMSException(ex.getMessage());
		}
	}
}
