/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.nvap.server.auth;

import gov.va.nvap.service.auth.ServiceAudit;
import gov.va.nvap.service.auth.ServiceAuditDAO;
import gov.va.nvap.service.auth.ServiceAuthenticationException;
import gov.va.nvap.service.auth.ServicePermission;
import gov.va.nvap.service.auth.ServicePermissionDAO;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.interceptor.Interceptors;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.handler.MessageContext;
import org.springframework.context.ApplicationContext;
import org.springframework.ejb.interceptor.SpringBeanAutowiringInterceptor;

/**
 *
 * @author 564685
 */
@Interceptors(SpringBeanAutowiringInterceptor.class)
public class ServiceAuthentication {

    public ServiceAudit checkAuth(WebServiceContext context, ApplicationContext applicationContext, String function) throws ServiceAuthenticationException {
        boolean authorized = false;
        HttpServletRequest hsr;
        ServiceAudit sa = new ServiceAudit();
        String cn = "Unknown";
        ServicePermissionDAO spdao = applicationContext.getBean(ServicePermissionDAO.class);
        try {
            hsr = (HttpServletRequest) context.getMessageContext().get(MessageContext.SERVLET_REQUEST);
            sa.setWebService(hsr.getContextPath().substring(1));
        } catch (IllegalStateException e) {
            return null; //Internal call
        }
        String address = hsr.getRemoteAddr();
        String servelet = hsr.getContextPath();
        sa.setEventDate(new Date());
        sa.setCN(cn);
        sa.setIp(address);
        sa.setWebService(servelet.substring(1));
        sa.setCall(function);
        sa.setAuthorized(false);
        X509Certificate[] certs = (X509Certificate[]) hsr.getAttribute("javax.servlet.request.X509Certificate");
        //if there exists a cerificate parse it
        if (certs != null && certs.length > 0) {
            try {
                String dn = certs[0].getSubjectDN().getName();

                LdapName parser;
                parser = new LdapName(dn);
                for (Rdn rdn : parser.getRdns()) {
                    if (rdn.getType().equalsIgnoreCase("CN")) {
                        cn = rdn.getValue().toString();
                        break;
                    }
                }
                if (cn == null) {
                    this.persist(applicationContext, sa);
                    this.returnError(context, "Certificate DN does not contain CN");
                }
                sa.setCN(cn);
                ServicePermission sp = spdao.checkAuthorization(cn);
                if (sp != null && sp.getEnabled()) {
                    authorized = true;
                } else {
                    sp = spdao.checkAuthorization("*wildcard*");
                    if (sp != null && sp.getEnabled()) {
                        Logger.getLogger(ServiceAuthentication.class.getName()).log(Level.INFO, "(" + cn + ") does not match any allowed Authorized Service but wildcard is enabled.");
                        authorized = true;
                    }
                }   
            } catch (InvalidNameException ex) {
                this.persist(applicationContext, sa);
                this.returnError(context, "Certificate contains invalid DN");
            }
        } 
        // no certificate
        else  {
            //check to see if system is disabled
            ServicePermission sp = spdao.checkAuthorization("*disable*");
            if (sp != null && sp.getEnabled()) {
                authorized = true;
                Logger.getLogger(ServiceAuthentication.class.getName()).log(Level.INFO, "No certificate passed but security is disabled.");
            }
            else{
                this.persist(applicationContext, sa);
                this.returnError(context, "Certificate was not passed");
            }
        }
        
        sa.setAuthorized(authorized);
        if (!authorized) {
            // Log the un-authorized call in the database. We do logging the call here to alleviate each of the calling
            // functions from having to do this after catching the error that this function raises.
            this.persist(applicationContext, sa);
            this.returnError(context, "Application is not authorized");
        }



        //return authorized;
        return sa;
    }

    private void returnError(WebServiceContext context, String message) throws ServiceAuthenticationException {
        HttpServletResponse hsr = (HttpServletResponse) context.getMessageContext().get(MessageContext.SERVLET_RESPONSE);
        try {
            hsr.sendError(403, message);
        } catch (IOException ex) {
            Logger.getLogger(ServiceAuthentication.class.getName()).log(Level.SEVERE, "Unable to return 403 response");
        }
        throw new ServiceAuthenticationException(message);
    }

    public ServiceAudit persist(ApplicationContext applicationContext, ServiceAudit serviceAudit) {
        ServiceAuditDAO sadao = applicationContext.getBean(ServiceAuditDAO.class);

        try {
            if (serviceAudit != null) //this will be null if it is an internal (dev) call as we don't want to log those
            {
                sadao.create(serviceAudit);
            }
        } catch (Exception ex) {
            Logger.getLogger(ServiceAuthentication.class.getName()).log(Level.SEVERE, "Unable to store service audit", ex);
        }

        return serviceAudit;
    }
}
