/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.nvap.server.announce.jpa;

import gov.va.nvap.common.validation.NullChecker;
import gov.va.nvap.privacy.ConsentType;
import gov.va.nvap.server.announce.AnnouncerControllerInterface;
import gov.va.nvap.svc.consentmgmt.PIPInterface;
import gov.va.nvap.svc.consentmgmt.jpa.OrganizationsJpaController;
import gov.va.nvap.svc.consentmgmt.jpa.exceptions.NonexistentEntityException;
import gov.va.nvap.svc.consentmgmt.stub.adapter.announce.data.Announcement;
import gov.va.nvap.svc.consentmgmt.stub.adapter.announce.data.AnnouncementBatchSummary;
import gov.va.nvap.svc.consentmgmt.stub.data.ConsentDirective;
import gov.va.nvap.svc.consentmgmt.stub.data.Organization;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;

import javax.persistence.EntityManager;
import javax.persistence.EntityNotFoundException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;

import org.springframework.beans.factory.annotation.Required;

/**
 * 
 * @author vhaislegberb
 * @author Irakli Kakushadze
 * @author Zack Peterson
 */
public class AnnouncementJpaController implements AnnouncerControllerInterface {

	private static final int MAX_RESULTS = 10000;

	@PersistenceContext(name = "VapEntityManager")
	private EntityManager em;

	/**
	 * The policy information point.
	 */
	private PIPInterface pip;
	
	@Required
	public void setPip(final PIPInterface pip) {
		this.pip = pip;
	}
	
	@Override
	public void create(final Announcement announcement) {
		this.em.persist(announcement);
	}

	@Override
	public String createAnnounceBatch(final Organization targetOrganization,
			final String userId, final Date dateRangeStart,
			final Date dateRangeStop, final boolean reannounce) {
    
		if (targetOrganization == null) {
			throw new IllegalArgumentException(
					"Target organization must not be null when created a announcement batch.");
		}

		// create a unique identifier for the batch
		final String batchId = UUID.randomUUID().toString();

		final StringBuilder sbQueryName = new StringBuilder(
				"ConsentDirective.active.notExcluded");
		sbQueryName
				.append(((dateRangeStart != null) && (dateRangeStop == null)) ? ".createdAftertDate"
						: "")
				.append(((dateRangeStart == null) && (dateRangeStop != null)) ? ".createdBeforeDate"
						: "")
				.append(((dateRangeStart != null) && (dateRangeStop != null)) ? ".createdBetweenDates"
						: "");

		if (reannounce) {
			sbQueryName.append(".Reannounce");
		}
		int firstResult = 0;

		// Setting the Consent Types here. For now, only non-consumer NwHin Organizations are being used for batch announcements.
		// When we add batch announcements for SSA, additional logic will need to be added here.
		final gov.va.nvap.svc.consentmgmt.stub.data.ConsentType consentTypeAuthorize = this.pip.getConsentTypeByName(ConsentType.NW_HIN_AUTHORIZATION.value());
		//final gov.va.nvap.svc.consentmgmt.stub.data.ConsentType consentTypeRestrict = this.pip.getConsentTypeByName(ConsentType.NW_HIN_ORGANIZATION_RESTRICTION_AUTHORIZATION.value());

		List<ConsentDirective> consentDirectives = null;
		final Date announceCreateDate = new Date();

		//System.out.println("*************************************************************");
		//System.out.println("DateTime before starting do loop: " + new Date());
		//System.out.println("*************************************************************");
		
		do {			
			Query q = this.em.createNamedQuery(sbQueryName.toString());
			q.setParameter("consentTypeAuthorize", consentTypeAuthorize);			
			//q.setParameter("consentTypeRestrict", consentTypeRestrict);
			
			if (dateRangeStart != null) {
				q.setParameter("afterDate", dateRangeStart);				
			}
			if (dateRangeStop != null) {
				q.setParameter("beforeDate", dateRangeStop);
			}

			//System.out.println("beforeDate Date: " + dateRangeStop.toString());
			//System.out.println("firstResult: " + firstResult);
			
			if (!reannounce) {
                //Look up the organization through the DAO to prevent construction of query with user-defined data.
                OrganizationsJpaController orgJpaController = new OrganizationsJpaController();
                Organization validatedOrg = orgJpaController.findOrganizationByOid(targetOrganization.getOrgOid());
                if (!NullChecker.isNullOrEmpty(validatedOrg)) {
                    q.setParameter("targetedOrganization", validatedOrg);
                }
                consentDirectives = q.setMaxResults(AnnouncementJpaController.MAX_RESULTS).getResultList();
			}else{
				consentDirectives = q.setFirstResult(firstResult * AnnouncementJpaController.MAX_RESULTS)
				.setMaxResults(AnnouncementJpaController.MAX_RESULTS).getResultList();				
			}
			
			for (final ConsentDirective cd : consentDirectives) {
				/*if (!reannounce) {
					q = this.em
					.createNamedQuery("Announcement.findByConsentDirectiveAndTargetOrg");
					q.setParameter("consentDirective", cd);
					q.setParameter("organization", targetOrganization);
					try {
						final List results = q.getResultList();
						if (NullChecker.isNotEmpty(results)) {
							continue;
						}
					} catch (final NoResultException nre) {
						// this is indicative of no announcement already exiting
						// for consent directive at target organization.
					}
				}*/

				// create a new announcement and persist it in the table.
				final Announcement announcement = new Announcement();
				announcement.setBatchId(batchId);
				announcement.setUserId(userId);
				announcement.setPatientConsentDir(cd);
				announcement.setTargetOrganization(targetOrganization);
				announcement.setCreatedTs(announceCreateDate);

				//System.out.println("Consent Directive ID: " + cd.getConsentDirId());

				this.em.persist(announcement);
			}
			firstResult++;			
			
			//System.out.println("-------------------------------------------------------------");
			//System.out.println("DateTime after finishing " + firstResult + " loop(s) of while: " + new Date());
			//System.out.println("-------------------------------------------------------------");

		} while ((consentDirectives != null)
				&& (consentDirectives.size() == AnnouncementJpaController.MAX_RESULTS));

		//System.out.println("*************************************************************");
		//System.out.println("DateTime after finishing do loop: " + new Date());
		//System.out.println("*************************************************************");

		return batchId;

	}

	@Override
	public String createAnnounceBatch(final Organization targetOrganization,
            final String userId, HashSet<String> iens) {
//        if (targetOrganization == null) {
//            throw new IllegalArgumentException("Target organization must not be null when creating an announcement batch.");
//        }

        // create a unique identifier for the batch
        final String batchId = UUID.randomUUID().toString();

        // Setting the Consent Types here. For now, only non-consumer NwHin Organizations are being used for batch announcements.
        // When we add batch announcements for SSA, additional logic will need to be added here.
        final gov.va.nvap.svc.consentmgmt.stub.data.ConsentType consentTypeAuthorize = this.pip.getConsentTypeByName(ConsentType.NW_HIN_AUTHORIZATION.value());

        final Date announceCreateDate = new Date();

        for (String ien : iens) {
            // create a new announcement and persist it in the table.
            final Announcement announcement = new Announcement();
            announcement.setBatchId(batchId);
            announcement.setUserId(userId);
            announcement.setPatientIen(ien);
            announcement.setTargetOrganization(targetOrganization);
            announcement.setCreatedTs(announceCreateDate);
            this.em.persist(announcement);
        }

        return batchId;        
    }
    
    @Override
	public String createAnnounceBatch(final Collection<Organization> targetOrganizations,
			final String userId, final Date dateRangeStart,
			final Date dateRangeStop, final boolean reannounce) {
    
		if (targetOrganizations == null) {
			throw new IllegalArgumentException(
					"Target organizations must not be null when created a announcement batch.");
		}

		// create a unique identifier for the batch
		final String batchId = UUID.randomUUID().toString();

		final StringBuilder sbQueryName = new StringBuilder(
				"ConsentDirective.active.notExcluded");
        if (!reannounce) {
			sbQueryName.append(".multOrgs");
		}
		sbQueryName
				.append(((dateRangeStart != null) && (dateRangeStop == null)) ? ".createdAftertDate"
						: "")
				.append(((dateRangeStart == null) && (dateRangeStop != null)) ? ".createdBeforeDate"
						: "")
				.append(((dateRangeStart != null) && (dateRangeStop != null)) ? ".createdBetweenDates"
						: "");

		if (reannounce) {
			sbQueryName.append(".Reannounce");
		}
		int firstResult = 0;

		// Setting the Consent Types here. For now, only non-consumer NwHin Organizations are being used for batch announcements.
		// When we add batch announcements for SSA, additional logic will need to be added here.
		final gov.va.nvap.svc.consentmgmt.stub.data.ConsentType consentTypeAuthorize = this.pip.getConsentTypeByName(ConsentType.NW_HIN_AUTHORIZATION.value());

		List<ConsentDirective> consentDirectives = null;
		final Date announceCreateDate = new Date();

		do {			
			Query q = this.em.createNamedQuery(sbQueryName.toString());
			q.setParameter("consentTypeAuthorize", consentTypeAuthorize);
			
			if (dateRangeStart != null) {
				q.setParameter("afterDate", dateRangeStart);				
			}
			if (dateRangeStop != null) {
				q.setParameter("beforeDate", dateRangeStop);
			}
			
			if (!reannounce) {
                q.setParameter("targetedOrganizations", targetOrganizations);
                consentDirectives = q.setMaxResults(AnnouncementJpaController.MAX_RESULTS).getResultList();
			}else{
				consentDirectives = q.setFirstResult(firstResult * AnnouncementJpaController.MAX_RESULTS)
				.setMaxResults(AnnouncementJpaController.MAX_RESULTS).getResultList();				
			}
			
			for (final ConsentDirective cd : consentDirectives) {
				// create a new announcement and persist it in the table.
				final Announcement announcement = new Announcement();
				announcement.setBatchId(batchId);
				announcement.setUserId(userId);
				announcement.setPatientConsentDir(cd);
				announcement.setTargetOrganization(null);
				announcement.setCreatedTs(announceCreateDate);

				this.em.persist(announcement);
			}
			firstResult++;			

		} while ((consentDirectives != null)
				&& (consentDirectives.size() == AnnouncementJpaController.MAX_RESULTS));

		return batchId;
	}
    
	public void destroy(final BigDecimal id) throws NonexistentEntityException {
		Announcement announcement;
		try {
			announcement = this.em.getReference(Announcement.class, id);
			announcement.getAnnouncementId();
		} catch (final EntityNotFoundException enfe) {
			throw new NonexistentEntityException("The announcement with id "
					+ id + " no longer exists.", enfe);
		}
		this.em.remove(announcement);
	}

	@Override
	public void edit(Announcement announcement)
			throws NonexistentEntityException, Exception {
		try {
			announcement = this.em.merge(announcement);
		} catch (final Exception ex) {
			final String msg = ex.getLocalizedMessage();
			if ((msg == null) || (msg.length() == 0)) {
				final Long id = announcement.getAnnouncementId();
				if (this.findAnnouncement(id) == null) {
					throw new NonexistentEntityException(
							"The announcement with id " + id
									+ " no longer exists.");
				}
			}
			throw ex;
		}
	}

	@Override
	public Announcement findAnnouncement(final Long id) {
		return this.em.find(Announcement.class, id);
	}

	@Override
	public List<Announcement> findAnnouncementEntities() {
		return this.findAnnouncementEntities(true, -1, -1);
	}

	private List<Announcement> findAnnouncementEntities(final boolean all,
			final int maxResults, final int firstResult) {
		final Query q = this.em
				.createQuery("select object(o) from Announcement as o");
		if (!all) {
			q.setMaxResults(maxResults);
			q.setFirstResult(firstResult);
		}
		return q.getResultList();
	}

	@Override
	public List<Announcement> findAnnouncementEntities(final int maxResults,
			final int firstResult) {
		return this.findAnnouncementEntities(false, maxResults, firstResult);
	}

    /**
     * Finds all announcements for a particular user.
     * 
     * @param userId User ID
     * @return List of objects of type Announcement found for this user
     */  
    @Override
    public List<Announcement> findAnnouncementsByUserId(final String userId) {
        final Query q = this.em.createNamedQuery("Announcement.findByUserId");
        q.setParameter("userId", userId);
        return q.getResultList();
    }
    
    /**
     * Finds all announcements for a list of consent directive ID numbers
     * 
     * @param consentDirectiveIds list of consent directive ID numbers
     * @return List of objects of type Announcement found for this patient
     */
    @Override
    public List<Announcement> findAnnouncementsByConsentDirectiveId(final List<Long> consentDirectiveIds) {
        final Query q = this.em.createNamedQuery("Announcement.findByConsentDirectiveIdList");
        q.setParameter("consentDirectiveIdList", consentDirectiveIds);
        return q.getResultList();
    }
    
	@Override
	public List<Announcement> findUnscheduledAnnouncementsByBatchId(
			final String batchId, final int maxAnnouncements, final int firstResult) {

		final Query q = this.em.createNamedQuery("Announcement.findByBatchId");
		q.setParameter("batchId", batchId);
		q.setFirstResult(firstResult*maxAnnouncements).setMaxResults(maxAnnouncements);
		return q.getResultList();
	}
    
    @Override
	public List<Announcement> findAllAnnouncementsByBatchId(final String batchId) {
		final Query q = this.em.createNamedQuery("Announcement.findByBatchId");
        q.setParameter("batchId", batchId);
		return q.getResultList();
	}

	@Override
	public int getAnnouncementCount() {
		final Query q = this.em
				.createQuery("select count(o) from Announcement as o");
		return ((Long) q.getSingleResult()).intValue();
	}

	@Override
	public void removeByBatchId(final Collection<String> batchIds) {
		final Query q = this.em
				.createNamedQuery("Announcement.deleteByBatchIds");
		q.setParameter("batchIds", batchIds);
		q.executeUpdate();
	}

    @Override
	public List<AnnouncementBatchSummary> retrieveBatchSummaries(final Date startDate, final Date endDate, final String orgOid, final String userId, final int firstResult, final int maxResults) {
        String query = "SELECT NEW gov.va.nvap.svc.consentmgmt.stub.adapter.announce.data.AnnouncementBatchSummary(a.batchId, o.orgName, o.orgId, COUNT(a.announcementId), MIN(a.createdTs), COUNT(a.scheduledTs), COUNT(a.completedTs)) FROM AnnouncementOrg j JOIN j.announcement a JOIN j.targetOrganization o WHERE a.batchId is not null";
        String queryParams = "";
        Query q = null;
        
        //build the query
        if(orgOid != null && orgOid.length() > 0){
            queryParams = queryParams + " AND o.orgOid=:orgOid";
        }
        
        queryParams = queryParams + " GROUP BY a.batchId, o.orgName, o.orgId";
        
        if(startDate != null && endDate != null){
            queryParams = queryParams + " HAVING MIN(a.createdTs) >= :startDate and MIN(a.createdTs) <= :endDate";
        } else {
            if(startDate != null){
                queryParams = queryParams + " HAVING MIN(a.createdTs) >= :startDate";
            }
            if(endDate != null){
                queryParams = queryParams + " HAVING MIN(a.createdTs) <= :endDate";
            }
        }
        
        query = query + queryParams + " ORDER BY MIN(a.createdTs) DESC";
        
        if (maxResults <= 0) {
            q = this.em.createQuery(query);
        } else {
            q = this.em.createQuery(query).setFirstResult(firstResult).setMaxResults(maxResults);
        }
        
        //add the params
        if(orgOid != null && orgOid.length() > 0){
            q.setParameter("orgOid", orgOid);
        }
        if(startDate != null){
            q.setParameter("startDate", startDate);
        }
        if(endDate != null){
            q.setParameter("endDate", endDate);
        }
        
        List<AnnouncementBatchSummary> results = q.getResultList();
        
        return results;
    }
    
	/*@Override
	public List<AnnouncementBatchSummary> retrieveBatchSummaries(
			final Date startDate, final Date endDate, final String orgOid,
			final String userId, final int firstResult, final int maxResults) {
		String query = null;
        String query2 = null;
		// TODO: Refactor - there must be a better way to do this, maybe % like
		// queries or Hibernate Criterias
		if ((null != userId) && (userId.length() > 0)) {
			if ((null != orgOid) && (orgOid.length() > 0)) {
				query = "Announcement.allBatchSummaryByOrganizationAndUserId";
                query2 = "Announcement.allBatchSummaryByOrganizationAndUserId2";
				if (null != startDate) {
					if (null != endDate) {
						query = "Announcement.batchSummaryByDateAndOrganizationAndUserId";
                        query2 = "Announcement.batchSummaryByDateAndOrganizationAndUserId2";
					} else {
						query = "Announcement.batchSummaryFromDateAndOrganizationAndUserId";
                        query2 = "Announcement.batchSummaryFromDateAndOrganizationAndUserId2";
					}
				} else if (null != endDate) {
					query = "Announcement.batchSummaryToDateAndOrganizationAndUserId";
                    query2 = "Announcement.batchSummaryToDateAndOrganizationAndUserId2";
				}

			} else {
				query = "Announcement.allBatchSummaryByUserId";
                query2 = "Announcement.allBatchSummaryByUserId2";
				if (null != startDate) {
					if (null != endDate) {
						query = "Announcement.batchSummaryByDateAndUserId";
                        query2 = "Announcement.batchSummaryByDateAndUserId2";
					} else {
						query = "Announcement.batchSummaryFromDateAndUserId";
                        query2 = "Announcement.batchSummaryFromDateAndUserId2";
					}
				} else if (null != endDate) {
					query = "Announcement.batchSummaryToDateAndUserId";
                    query2 = "Announcement.batchSummaryToDateAndUserId2";
				}
			}
		} else {
			if ((null != orgOid) && (orgOid.length() > 0)) {
				query = "Announcement.allBatchSummaryByOrganization";
                query2 = "Announcement.allBatchSummaryByOrganization2";
				if (null != startDate) {
					if (null != endDate) {
						query = "Announcement.batchSummaryByDateAndOrganization";
                        query2 = "Announcement.batchSummaryByDateAndOrganization2";
					} else {
						query = "Announcement.batchSummaryFromDateAndOrganization";
                        query2 = "Announcement.batchSummaryFromDateAndOrganization2";
					}
				} else if (null != endDate) {
					query = "Announcement.batchSummaryToDateAndOrganization";
                    query2 = "Announcement.batchSummaryToDateAndOrganization2";
				}

			} else {
				query = "Announcement.allBatchSummary";
                query2 = "Announcement.allBatchSummary2";
				if (null != startDate) {
					if (null != endDate) {
						query = "Announcement.batchSummaryByDate";
                        query2 = "Announcement.batchSummaryByDate2";
					} else {
						query = "Announcement.batchSummaryFromDate";
                        query2 = "Announcement.batchSummaryFromDate2";
					}
				} else if (null != endDate) {
					query = "Announcement.batchSummaryToDate";
                    query2 = "Announcement.batchSummaryToDate2";
				}
			}
		}

		final Query q = this.em.createNamedQuery(query);
        final Query q2 = this.em.createNamedQuery(query2);
		if (null != startDate) {
			q.setParameter("startDate", startDate);
            q2.setParameter("startDate", startDate);
		}
		if (null != endDate) {
			q.setParameter("endDate", endDate);
            q2.setParameter("endDate", endDate);
		}
		if ((null != orgOid) && (orgOid.length() > 0)) {
			q.setParameter("orgOid", orgOid);
            q2.setParameter("orgOid", orgOid);
		}
		if ((null != userId) && (userId.length() > 0)) {
			q.setParameter("userId", userId);
            q2.setParameter("userId", userId);
		}
		if (maxResults <= 0) {
            List<AnnouncementBatchSummary> results = q.getResultList();
            results.addAll(q2.getResultList());
			return results;
		} else {
            List<AnnouncementBatchSummary> results = q.getResultList();
            results.addAll(q2.getResultList());
            results = results.subList(firstResult, firstResult + maxResults > results.size() ? results.size() : firstResult + maxResults);
			return results;
		}
	} */

	@Override
	public List<AnnouncementBatchSummary> retrieveBatchSummaries(
			final List<String> batchIds) {
		final Query q = this.em.createNamedQuery("Announcement.batchSummary");
		q.setParameter("batchIds", batchIds);
		return q.getResultList();
	}

	@Override
	public List<AnnouncementBatchSummary> retrieveBatchSummariesByDateRange(
			final Date startDate, final Date endDate) {
		return this.retrieveBatchSummaries(startDate, endDate, null, null, 0,
				-1);
	}
    
    /**
     * Finds all announcements created after input date for a particular patient.
     * 
     * @param createdTs
     * @param patientIen
     * 
     * @return List of objects of type Announcement found for this patient
     */  
    @Override
    public List<Announcement> findNonBatchAnnouncementsByCreatedTs(final Date createdTs, final String patientIen) {
        final Query q = this.em.createNamedQuery("Announcement.findNonBatchAnnouncementsByCreatedTs");
        q.setParameter("createdTs", createdTs);
        q.setParameter("patientIen", patientIen);
        return q.getResultList();
    }

	@Override
	public void setEntityManager(final EntityManager em) {
		this.em = em;
	}
    
    @Override
	public HashMap findAllAnnouncementsByBatchIdWithPaging(final String batchId, final String orgId, final Integer startRow, final Integer maxRows) {
        HashMap hm = new HashMap();
        
        final Query cq = this.em.createNamedQuery("Announcement.findCountByBatchIdAndOrgId");
        cq.setParameter("batchId", batchId);
        cq.setParameter("orgId", Long.parseLong(orgId));
        Long c = Long.parseLong(cq.getSingleResult().toString());
        
        hm.put("count", c);
        
        final Query q = this.em.createNamedQuery("Announcement.findByBatchIdAndOrgId").setFirstResult(startRow).setMaxResults(maxRows);
        q.setParameter("batchId", batchId);
        q.setParameter("orgId", Long.parseLong(orgId));
		List<Announcement> results = q.getResultList(); 
        
        hm.put("results", results);
        
        return hm;
	}
}
