/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.nvap.server.announce;

import gov.va.nvap.svc.consentmgmt.AnnouncementOrgControllerInterface;
import gov.va.nvap.svc.consentmgmt.jpa.exceptions.PreexistingEntityException;
import gov.va.nvap.svc.consentmgmt.stub.adapter.announce.data.Announcement;
import gov.va.nvap.svc.consentmgmt.stub.adapter.announce.data.AnnouncementBatchSummary;
import gov.va.nvap.svc.consentmgmt.stub.adapter.announce.data.AnnouncementOrg;
import gov.va.nvap.svc.consentmgmt.stub.adapter.announce.data.AnnouncerInterface;
import gov.va.nvap.svc.consentmgmt.stub.data.Organization;
import java.util.ArrayList;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.springframework.beans.factory.annotation.Required;

/**
 * 
 * @author vhaislegberb
 * @author Irakli Kakushadze
 * @author Zack Peterson
 */
public class AnnouncerImpl implements AnnouncerInterface {
    private AnnouncerControllerInterface patientAnnounceController;
    
    private AnnouncementOrgControllerInterface announcementOrgController;
    
    /*
	 * Timeframe to block Opt-In Announcements
	 */
	private int announceExclusionTimeframeHours;

	@Override
	public String createAnnouncementsBatch(
			final Organization targetedOrganization, final String userId,
			final Date dateRangeStart, final Date dateRangeStop,
			final boolean reannounce) {

		return this.patientAnnounceController.createAnnounceBatch(
				targetedOrganization, userId, dateRangeStart, dateRangeStop,
				reannounce);
	}

 	@Override
	public String createAnnouncementsBatch(
			final Organization targetedOrganization, final String userId, HashSet<String> iens) {

		return this.patientAnnounceController.createAnnounceBatch(targetedOrganization, userId, iens);
	}
    
    @Override
    public String createAnnouncementsBatch(
			final Collection<Organization> targetedOrganizations, final String userId,
			final Date dateRangeStart, final Date dateRangeStop,
			final boolean reannounce) {

		String batchId = this.patientAnnounceController.createAnnounceBatch(
				targetedOrganizations, userId, dateRangeStart, dateRangeStop,
				reannounce);

        return batchId;
	}

 	@Override
	public String createAnnouncementsBatch(
			final Collection<Organization> targetedOrganizations, final String userId, HashSet<String> iens) {

		String batchId = this.patientAnnounceController.createAnnounceBatch(null, userId, iens);

        return batchId;
	}

    @Override
    public void createAnnouncementOrg(AnnouncementOrg announceOrg) {
        try {
            this.announcementOrgController.create(announceOrg);
        } catch (PreexistingEntityException ex) {
            // AnnounceOrg already exists
        } catch (Exception ex) {
            // AnnounceOrg storage fail
        }
    }

	@Override
	public Announcement getAnnouncementById(final Long announcementId) {
		return this.patientAnnounceController.findAnnouncement(announcementId);
	}

    /**
     * Finds all announcements for a particular user.
     * 
     * @param userId User ID
     * @return List of objects of type Announcement found for this user
     */
    @Override
    public List<Announcement> getAnnouncementsByUserId(String userId) {
        return this.patientAnnounceController.findAnnouncementsByUserId(userId);
    }
    
    /**
     * Finds all announcements for a list of consent directive ID numbers
     * 
     * @param consentDirectiveIds list of consent directive ID numbers
     * @return List of objects of type Announcement found for this patient
     */
    @Override
    public List<Announcement> getAnnouncementsByConsentDirectiveId(List<Long> consentDirectiveIds) {
        return this.patientAnnounceController.findAnnouncementsByConsentDirectiveId(consentDirectiveIds);
    }
    
    /**
     * Finds all announcements created after input date for a particular patient.
     * 
     * @param createdTs
     * @param patientIen
     *
     * @return List of objects of type Announcement found for this patient
     */
    @Override
    public List<Announcement> getNonBatchAnnouncementsByCreatedTs(Date createdTs, String patientIen) {
        return this.patientAnnounceController.findNonBatchAnnouncementsByCreatedTs(createdTs, patientIen);
    }

	@Override
	public List<AnnouncementBatchSummary> getBatchSummary(
			final List<String> batchIds) {
        List<AnnouncementBatchSummary> summaries = 
                this.announcementOrgController.retrieveBatchSummaries(batchIds);
        if (summaries == null || summaries.isEmpty()) {
            return this.patientAnnounceController.retrieveBatchSummaries(batchIds);
        }
        return summaries;
	}
    
    @Override
    public void removeByAnnouncement(Announcement announcement) {
        try {
            this.announcementOrgController.removeByAnnouncement(announcement);
        } catch (Exception ex) {
            // AnnounceOrg destroy fail
        }
    }

	@Override
	public List<AnnouncementBatchSummary> getBatchSummaryByDateRange(
			final Date startDate, final Date endDate) {
		return this.patientAnnounceController
				.retrieveBatchSummariesByDateRange(startDate, endDate);
	}

	@Override
	public Collection<Announcement> getUnscheduledAnnouncementsByBatchId(
			final String batchId, final int maxAnnouncements, final int firstResult) {
		return this.patientAnnounceController
				.findUnscheduledAnnouncementsByBatchId(batchId,
						maxAnnouncements, firstResult);
	}

	@Override
	public void removeAnnouncementBatches(final Collection<String> batchIds)
			throws AnnouncerException {
        for (String batchId : batchIds) {
            List<Announcement> announcements = this.patientAnnounceController.findAllAnnouncementsByBatchId(batchId);
            for (Announcement announcement : announcements) {
                this.announcementOrgController.removeByAnnouncement(announcement);
            }
        }
		this.patientAnnounceController.removeByBatchId(batchIds);
	}

	@Override
	public List<AnnouncementBatchSummary> retrieveBatchSummaries(
			final Date startDate, final Date endDate, final String orgOid,
			final String userId, final int firstResult, final int maxResults) {
		return this.patientAnnounceController.retrieveBatchSummaries(startDate,
				endDate, orgOid, userId, firstResult, maxResults);
	}

	/**
	 * @param patientAnnounceController
	 */
	public void setPatientAnnounceController(
			final AnnouncerControllerInterface patientAnnounceController) {
		this.patientAnnounceController = patientAnnounceController;
	}

	@Override
	public void storeAnnouncement(final Announcement announcement) {
		if (announcement.getAnnouncementId() == null) {
			try {
				this.patientAnnounceController.create(announcement);
			} catch (final Exception ex) {
				throw new AnnouncerException(
						"An error occurred while creating the new announcement in the persistent store.",
						ex);
			}
		} else {
			try {
				this.patientAnnounceController.edit(announcement);
			} catch (final Exception ex) {
				throw new AnnouncerException(
						"An error occured while updating the announcement.", ex);
			}
		}
	}

    public AnnouncementOrgControllerInterface getAnnouncementOrgController() {
        return announcementOrgController;
    }

    public void setAnnouncementOrgController(AnnouncementOrgControllerInterface announcementOrgController) {
        this.announcementOrgController = announcementOrgController;
    }
    
    @Required
    public void setAnnounceExclusionTimeframeHours(int announceExclusionTimeframeHours) {
        this.announceExclusionTimeframeHours = announceExclusionTimeframeHours;
    }
    
    @Override
    public int getAnnounceExclusionTimeframeHours() {
		return this.announceExclusionTimeframeHours;
	}
    
    @Override
    public List<AnnouncementOrg> getAnnouncementOrgsByAnnouncement(final Announcement announcement) {
        return this.announcementOrgController.findAnnouncementOrgsByAnnouncement(announcement);
    }
    
    @Override
    public HashMap getAnnouncementsByBatchIdWithPaging(String batchId, String orgId, Integer startRow, Integer maxRows) {
        return this.patientAnnounceController.findAllAnnouncementsByBatchIdWithPaging(batchId, orgId, startRow, maxRows);
    }
}
