/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package gov.va.nvap.server.announce;

import gov.va.nvap.svc.consentmgmt.jpa.exceptions.NonexistentEntityException;
import gov.va.nvap.svc.consentmgmt.stub.adapter.announce.data.Announcement;
import gov.va.nvap.svc.consentmgmt.stub.adapter.announce.data.AnnouncementBatchSummary;
import gov.va.nvap.svc.consentmgmt.stub.data.Organization;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

import javax.persistence.EntityManager;

/**
 * 
 * @author vhaislegberb
 * @author Irakli Kakushadze
 * @author Zack Peterson
 */
public interface AnnouncerControllerInterface {

	void create(Announcement announcement);

	/**
	 * Creates a batch of announcements based on the provided parameters and
	 * returns the batch identifier to the invoker for further processing.
	 * 
	 * @param targetOrganization
	 *            The target organization or who the announcement is for.
	 * @param dateRangeStart
	 *            The start date of the date range to be used and applied to the
	 *            consent directive create date.
	 * @param dateRangeStop
	 *            The stop date of the date range to be used and applied to the
	 *            consent directive create date.
	 * @param reannounce
	 *            Flag that indicates whether a re-announce should be performed
	 *            or not.
	 * @return The unique identifier for the batch.
	 */
	String createAnnounceBatch(Organization targetOrganization, String userId,
			Date dateRangeStart, Date dateRangeStop, boolean reannounce);

	String createAnnounceBatch(Organization targetOrganization, String userId, HashSet<String> iens);
    
    public String createAnnounceBatch(final Collection<Organization> targetOrganizations,
			final String userId, final Date dateRangeStart,
			final Date dateRangeStop, final boolean reannounce);

	void edit(Announcement announcement) throws NonexistentEntityException,
			Exception;

	Announcement findAnnouncement(Long id);

	List<Announcement> findAnnouncementEntities();

	List<Announcement> findAnnouncementEntities(int maxResults, int firstResult);

    /**
     * Finds all announcements for a particular user.
     * 
     * @param userId User ID
     * @return List of objects of type Announcement found for this user
     */
    public List<Announcement> findAnnouncementsByUserId(String userId);
    
    /**
     * Finds all announcements for a list of consent directive ID numbers
     * 
     * @param consentDirectiveIds list of consent directive ID numbers
     * @return List of objects of type Announcement found for this patient
     */
    public List<Announcement> findAnnouncementsByConsentDirectiveId(List<Long> consentDirectiveIds);
    
	public List<Announcement> findUnscheduledAnnouncementsByBatchId(
			String batchId, int maxAnnouncements, int firstResult);

	int getAnnouncementCount();

	/**
	 * Removes all announcement records that belong to the batch specified by
	 * the batchIds parameter.
	 * 
	 * @param batchIds
	 *            The batch identifiers whose announcements are to be removed.
	 */
	void removeByBatchId(Collection<String> batchIds);

	/**
	 * Get the list of announcement batch summaries by date range, organization.
	 * 
	 * @param startDate
	 *            the start date (optional)
	 * @param endDate
	 *            the end date (optional)
	 * @param orgOid
	 *            the organization OID (optional)
	 * @param userId
	 *            the organization OID (optional)
	 * @param firstResult
	 *            the index to start the first record (optional)
	 * @param the
	 *            maximum number of results (optional)
	 * @return list of batch summaries
	 */
	List<AnnouncementBatchSummary> retrieveBatchSummaries(Date startDate,
			Date endDate, String orgOid, String userId, int firstResult,
			int maxResults);

	/**
	 * Retrieve the list of batch summaries that relate to the batch identifiers
	 * passed in as a parameter.
	 * 
	 * @param batchIds
	 *            The list of batch identifiers to retrieve summaries for.
	 * @return The list of batch summaries.
	 */
	public List<AnnouncementBatchSummary> retrieveBatchSummaries(
			List<String> batchIds);

	List<AnnouncementBatchSummary> retrieveBatchSummariesByDateRange(
			Date startDate, Date endDate);

    List<Announcement> findNonBatchAnnouncementsByCreatedTs(final Date createdTs, String patientIen);
    
	void setEntityManager(EntityManager em);

    List<Announcement> findAllAnnouncementsByBatchId(final String batchId);
    
    HashMap findAllAnnouncementsByBatchIdWithPaging(final String batchId, final String orgId, final Integer startRow, final Integer maxRows);
}
