package gov.va.nvap.mock.endpoint.vista;

import gov.va.nvap.common.endpoint.EndpointException;
import gov.va.nvap.common.file.FileUtil;
import gov.va.nvap.common.validation.Assert;
import gov.va.nvap.mock.dao.PatientProfileDAO;
import gov.va.nvap.mock.endpoint.mvi.PatientProfile;
import java.text.SimpleDateFormat;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;

public class MockVistAExtendedViewEndpoint implements
		gov.va.nvap.common.endpoint.Endpoint<Object, String> {

	@Autowired
	ApplicationContext applicationContext;

	@Override
	public String invoke(final Object obj) throws EndpointException {
		try {
                            Assert.assertNotEmpty(obj, "ICN is required!");

                            // CHDRONE
                            if ("1012581676V377802".contains((String) obj)) {
                                    final Resource resource = this.applicationContext
                                                    .getResource("classpath:gov/va/nvap/mock/endpoint/vista/mvi/MPI RETURN CORRELATION DATA.txt");
                                    final String extendedViewData = FileUtil.getResource(resource);
                                    return extendedViewData;
                            } else if ("123456".equals(obj)) {
                                    final Resource resource = this.applicationContext
                                                    .getResource("classpath:gov/va/nvap/mock/endpoint/vista/mvi/MPI RETURN CORRELATION DATA_MPIPATIENT_ONE.txt");
                                    final String extendedViewData = FileUtil.getResource(resource);
                                    return extendedViewData;
                            } else if ("123457".equals(obj)) {
                                    final Resource resource = this.applicationContext
                                                    .getResource("classpath:gov/va/nvap/mock/endpoint/vista/mvi/MPI RETURN CORRELATION DATA_MPIPATIENT_ONE.txt");
                                    final String extendedViewData = FileUtil.getResource(resource);
                                    return extendedViewData;
                            } else if ("123458".equals(obj)) {
                                    final Resource resource = this.applicationContext
                                                    .getResource("classpath:gov/va/nvap/mock/endpoint/vista/mvi/MPI RETURN CORRELATION DATA_MPIPATIENT_ONE.txt");
                                    final String extendedViewData = FileUtil.getResource(resource);
                                    return extendedViewData;
                            } else if ("123460".equals(obj)) {
                                    final Resource resource = this.applicationContext
                                                    .getResource("classpath:gov/va/nvap/mock/endpoint/vista/mvi/MPI RETURN CORRELATION DATA_MPIPATIENT_ONE.txt");
                                    final String extendedViewData = FileUtil.getResource(resource);
                                    return extendedViewData;
                            } else if ("123459".equals(obj)) {
                                    final Resource resource = this.applicationContext
                                                    .getResource("classpath:gov/va/nvap/mock/endpoint/vista/mvi/MPI RETURN CORRELATION DATA_MPIPATIENT_ONE.txt");
                                    final String extendedViewData = FileUtil.getResource(resource);
                                    return extendedViewData;
                            } else if ("1111111111V111111".equals(obj)) {
                                    final Resource resource = this.applicationContext
                                                    .getResource("classpath:gov/va/nvap/mock/endpoint/vista/mvi/MPI RETURN CORRELATION DATA_MPIPATIENT_ONE.txt");
                                    final String extendedViewData = FileUtil.getResource(resource);
                                    return extendedViewData;
                            } else if ("2222222222V222222".equals(obj)) {
                                    final Resource resource = this.applicationContext
                                                    .getResource("classpath:gov/va/nvap/mock/endpoint/vista/mvi/MPI RETURN CORRELATION DATA_MPIPATIENT_ONE_2.txt");
                                    final String extendedViewData = FileUtil.getResource(resource);
                                    return extendedViewData;
                            } else if ("3333333333V333333".equals(obj)) {
                                    final Resource resource = this.applicationContext
                                                    .getResource("classpath:gov/va/nvap/mock/endpoint/vista/mvi/MPI RETURN CORRELATION DATA_MPIPATIENT_ONE.txt");
                                    final String extendedViewData = FileUtil.getResource(resource);
                                    return extendedViewData;
                            } else if ("4444444444V444444".equals(obj)) {
                                    final Resource resource = this.applicationContext
                                                    .getResource("classpath:gov/va/nvap/mock/endpoint/vista/mvi/MPI RETURN CORRELATION DATA_MPIPATIENT_ONE.txt");
                                    final String extendedViewData = FileUtil.getResource(resource);
                                    return extendedViewData;
                            } else {
                                // get the demographic data from the database for this user by ien
                                PatientProfileDAO dao = applicationContext.getBean(PatientProfileDAO.class);
                                PatientProfile p = dao.getByIEN(obj.toString());
                                SimpleDateFormat inputFormat = new SimpleDateFormat("yyyy-MM-dd");
                                SimpleDateFormat outputFormat = new SimpleDateFormat("MMM dd, yyyy");

                                Resource resource = this.applicationContext.getResource("classpath:gov/va/nvap/mock/endpoint/vista/mvi/MPI RETURN CORRELATION DATA MACROS.txt");
                                String corrData = FileUtil.getResource(resource);

                                //do the replaces
                                corrData = corrData.replace("[ien]", p.getIEN());
                                corrData = corrData.replace("[ssn]", p.getSSN());
                                corrData = corrData.replace("[lastname]", p.getLastName());
                                corrData = corrData.replace("[firstname]", p.getFirstName());
                                corrData = corrData.replace("[middleinitial]", p.getMiddleInitial());
                                corrData = corrData.replace("[gender]", p.getGender().toUpperCase());
                                corrData = corrData.replace("[dob]", outputFormat.format(inputFormat.parse(p.getDateOfBirth())).toUpperCase());

                                return corrData;
                            }
                        } catch (Exception ex) {
			throw new RuntimeException(ex);
		}
	}
}
