package gov.va.nvap.mock.endpoint.permission.pdp;

import java.util.List;

import gov.va.nvap.service.permission.pdp.PDPInterface;
import gov.va.nvap.svc.consenteval.common.XACMLContextConstants;
import static gov.va.nvap.svc.consenteval.common.XACMLContextConstants.RESOURCE_CONF_CODE_ATTR_ID;
import static gov.va.nvap.svc.consenteval.common.XACMLContextConstants.STRING_ATTR_DATA_TYPE;
import static gov.va.nvap.svc.consenteval.common.XACMLContextConstants.XACML_REQUEST_SUBJECT_PURPOSE_FOR_USE_ATTR_ID;
import gov.va.nvap.svc.consenteval.common.XACMLContextUtil;
import gov.va.nvap.svc.consenteval.common.XACMLRequestParser;
import oasis.names.tc.xacml._2_0.context.schema.os.DecisionType;
import oasis.names.tc.xacml._2_0.context.schema.os.RequestType;
import oasis.names.tc.xacml._2_0.context.schema.os.ResponseType;
import oasis.names.tc.xacml._2_0.context.schema.os.ResultType;
import oasis.names.tc.xacml._2_0.policy.schema.os.AttributeAssignmentType;
import oasis.names.tc.xacml._2_0.policy.schema.os.EffectType;
import oasis.names.tc.xacml._2_0.policy.schema.os.ObligationType;
import oasis.names.tc.xacml._2_0.policy.schema.os.ObligationsType;

/**
 *
 * @author cbarber
 */
public class MockPDPServiceEndpoint implements PDPInterface
{
    public static final String SAMPLE_OBLIGATION_LABEL_POU = "urn:gov.va.nhin.obligation.label-pou";
    public static final String SAMPLE_POU_VALUE_TREATMENT = "TREATMENT";
    
    @Override
    public ResponseType checkPolicy(RequestType body)
    {
    	/**
    	 * If not docQuery or DocRetrieve return true
    	 */
    	if (!XACMLRequestParser.isDocQuery(body) && !XACMLRequestParser.isDocRetrieve(body))
        {
    		return generateResponse(true);
        }
    	
    	/**
    	 * If the confidentiality code is "NORMAL" generateResponse(true) else false
    	 */
        List<String> confidentialityCodeList = XACMLContextUtil.getResourceAttributeValues(
        		body, RESOURCE_CONF_CODE_ATTR_ID);
    	
		if ((confidentialityCodeList != null) && (confidentialityCodeList.size() > 0)) 
		{
            String confCode = confidentialityCodeList.get(0);
            if(XACMLContextConstants.RESOURCE_CONF_CODE_VAL_NORMAL.equals(confCode))
			{
                return generateResponse(true);
			}		
		}
		
		
    	/**
    	 * Determine the Opt-In resource value and call generateResponse with boolean value
    	 */
    	boolean isPatientOptedIn = false;
        List<String> optInList = XACMLContextUtil.getResourceAttributeValues(
        		body, XACMLContextConstants.RESOURCE_OPTIN_ATTR_ID);
        
		if ((optInList != null) && (optInList.size() > 0)) 
		{
			isPatientOptedIn = XACMLContextConstants.RESOURCE_OPTIN_YES_VALUE
					.equals(optInList.get(0));
		}
    	
        return generateResponse(isPatientOptedIn);
    }
    

    // TODO first part copied from PolicyEvaluationServiceImpl ... see about factoring
    // out into common library.
	public static ResponseType generateResponse(final boolean authorized)
    {
		final ResponseType response = new ResponseType();
		final List<ResultType> results = response.getResult();
		final ResultType result = new ResultType();
		result.setDecision(authorized ? DecisionType.PERMIT : DecisionType.DENY);
        
        //***
        // Add an obligation to test that it is forwarded in response from VAP
        //***
        if(authorized)
        {
            // the actual obligation
            ObligationType sampleOblig = new ObligationType();
            sampleOblig.setObligationId(SAMPLE_OBLIGATION_LABEL_POU);
            sampleOblig.setFulfillOn(EffectType.PERMIT);
            AttributeAssignmentType obligAttr = new AttributeAssignmentType();
            obligAttr.setAttributeId(XACML_REQUEST_SUBJECT_PURPOSE_FOR_USE_ATTR_ID);
            obligAttr.setDataType(STRING_ATTR_DATA_TYPE);
            obligAttr.getContent().add(SAMPLE_POU_VALUE_TREATMENT);
            sampleOblig.getAttributeAssignment().add(obligAttr);

            // wire it into the result
            ObligationsType obligsParent = new ObligationsType();
            obligsParent.getObligation().add(sampleOblig);
            result.setObligations(obligsParent);
        }
		results.add(result);
        return response;
	}    
}
