package gov.va.nvap.mock.endpoint.mvi;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;

/**
 *
 * @author Johann Sonnenberg 
 */
@Entity
@Table(name = "PATIENT_PROFILE")
@NamedQueries({
		@NamedQuery(name = "PatientProfile.findAll", query = "SELECT p FROM PatientProfile p"),
		@NamedQuery(name = "PatientProfile.findByIEN", query = "SELECT p FROM PatientProfile p WHERE p.ien = :ien") })
public class PatientProfile implements Serializable {
    private static final long serialVersionUID = 1L;

    @Id
    @Column(name = "IEN")
    private String ien;

    @Column(name = "LAST_NAME")
    private String lastName;

    @Column(name = "FIRST_NAME")
    private String firstName;

    @Column(name = "MIDDLE_INITIAL")
    private String middleInitial;

    @Column(name = "DOB")
    private String dateOfBirth;

    @Column(name = "GENDER")
    private String gender;

    @Column(name = "SSN")
    private String ssn;

    public PatientProfile() {
    }

    public PatientProfile(final String ien) {
            this.ien = ien;
    }

    @Override
    public boolean equals(final Object object) {
        if (!(object instanceof PatientProfile)) {
                return false;
        }
        
        final PatientProfile other = (PatientProfile) object;
        
        if (((this.ien == null) && (other.ien != null))
                        || ((this.ien != null) && !this.ien.equals(other.ien))) {
                return false;
        }
        return true;
    }

    public String getIEN() {
        return this.ien;
    }

    public void setIEN(final String ien) {
        this.ien = ien;
    }
    
    public String getLastName() {
        return this.lastName;
    }
    
    public void setLastName(final String lastName) {
        this.lastName = lastName;
    }
    
    public String getFirstName() {
        return this.firstName;
    }
    
    public void setFirstName(final String firstName) {
        this.firstName = firstName;
    }
    
    public String getMiddleInitial() {
        if(this.middleInitial == null) {
            return "";
        } else {
            return this.middleInitial;
        }
    }
    
    public void setMiddleInitial(final String middleInitial) {
        this.middleInitial = middleInitial;
    }
    
    public String getDateOfBirth() {
        return this.dateOfBirth;
    }
    
    public void setDateOfBirth(final String dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
    }
    
    public String getGender() {
        return this.gender;
    }
    
    public void setgender(final String gender) {
        this.gender = gender;
    }
    
    public String getSSN() {
        return this.ssn;
    }
    
    public void setSSN(final String ssn) {
        this.ssn = ssn;
    }
    
    @Override
    public int hashCode() {
        int hash = 0;
        hash += (this.ien != null ? this.ien.hashCode() : 0);
        return hash;
    }
}