package gov.va.nvap.mock.endpoint.mvi;

import gov.va.nvap.common.file.FileUtil;
import gov.va.nvap.common.transceiver.client.Transceiver;
import gov.va.nvap.mock.dao.PatientProfileDAO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public class MockSocketTransceiver implements Transceiver<String> {

	@Autowired
	ApplicationContext applicationContext;
        
	@Override
	public String transceive(final String payload) {
		try {
                        if (payload.contains("QBP~Q22")
					&& payload.toLowerCase().contains("chdrone")) {
                            
                            final org.springframework.core.io.Resource resource = this.applicationContext
                                            .getResource("classpath:gov/va/nvap/mock/endpoint/mvi/RSP_K22_SingleMatch.er7");
                            final String rspK22ER7 = FileUtil.getResource(resource);
                            return rspK22ER7;
			}
			if (payload.contains("QBP~Q22")
					&& payload.toLowerCase().contains("mpipatient")
					&& payload.contains("ONE")) {
				final org.springframework.core.io.Resource resource = this.applicationContext
						.getResource("classpath:gov/va/nvap/mock/endpoint/mvi/RSP_K22_MultipleMatches.er7");
				final String rspK22ER7 = FileUtil.getResource(resource);
				return rspK22ER7;
			} else if (payload.contains("QBP~Q22")
					&& payload.toLowerCase().contains("chdrtwo")) {
				final org.springframework.core.io.Resource resource = this.applicationContext
						.getResource("classpath:gov/va/nvap/mock/endpoint/mvi/RSP_K22_MultipleMatches.er7");
				final String rspK22ER7 = FileUtil.getResource(resource);
				return rspK22ER7;
			} else if (payload.contains("QBP~Q22")
					&& payload.toLowerCase().contains("error")) {
				final org.springframework.core.io.Resource resource = this.applicationContext
						.getResource("classpath:gov/va/nvap/mock/endpoint/mvi/RSP_K22_Failure.er7");
				final String rspK22ER7 = FileUtil.getResource(resource);
				return rspK22ER7;
			} else {
                            PatientProfileDAO dao = applicationContext.getBean(PatientProfileDAO.class);
                        
                            // get the ssn, firstname, and lastname from the payload
                            String list[] = payload.split("~");
                            String ssn = list[19];
                            String lastName = list[5];
                            String firstName = list[6];

                            //get the payload from the database based on the params passed
                            String load = dao.getPayload(ssn, lastName, firstName);

                            return load;
			}
		} catch (final Exception ex) {
			throw new RuntimeException(ex);
		}
	}

}
