//package gov.va.nvap.mock.endpoint.mvi;
//
//import gov.va.nvap.mock.dao.PatientProfileDAO;
//import gov.va.oit.oed.vaww.PRPAIN201305UV02;
//import gov.va.oit.oed.vaww.PRPAIN201306UV02;
//import gov.va.oit.oed.vaww.PRPAIN201309UV02;
//import java.io.Serializable;
//import java.util.Collection;
//import java.util.List;
//import javax.xml.bind.JAXBElement;
//import org.hl7.v3.CE;
//import org.hl7.v3.CS;
//import org.hl7.v3.ENExplicit;
//import org.hl7.v3.EnExplicitFamily;
//import org.hl7.v3.EnExplicitGiven;
//import org.hl7.v3.II;
//import org.hl7.v3.ObjectFactory;
//import org.hl7.v3.PNExplicit;
//import org.hl7.v3.PRPAIN201306UV02MFMIMT700711UV01ControlActProcess;
//import org.hl7.v3.PRPAIN201306UV02MFMIMT700711UV01RegistrationEvent;
//import org.hl7.v3.PRPAIN201306UV02MFMIMT700711UV01Subject1;
//import org.hl7.v3.PRPAIN201306UV02MFMIMT700711UV01Subject2;
//import org.hl7.v3.PRPAIN201310UV02;
//import org.hl7.v3.PRPAIN201310UV02MFMIMT700711UV01ControlActProcess;
//import org.hl7.v3.PRPAMT201306UV02LivingSubjectName;
//import org.hl7.v3.PRPAMT201306UV02ParameterList;
//import org.hl7.v3.PRPAMT201310UV02OtherIDs;
//import org.hl7.v3.PRPAMT201310UV02Patient;
//import org.hl7.v3.PRPAMT201310UV02Person;
//import org.springframework.beans.factory.annotation.Autowired;
//import org.springframework.context.ApplicationContext;
//import org.springframework.ws.client.core.WebServiceTemplate;
//
///**
// * This class represents mock MVI web service template.
// * 
// * @author Irakli Kakushadze
// * @since 12/06/2016
// */
//public class MockMviSoapWebServiceTemplate extends WebServiceTemplate {
//
//    private final String VA_OID = "2.16.840.1.113883.4.349";
//
//    @Autowired
//    ApplicationContext applicationContext;
//
//    @Autowired
//    PatientProfileDAO patientProfileDao;
//
//    @Override
//    public Object marshalSendAndReceive(final Object requestPayload) {
//
//        if (requestPayload instanceof PRPAIN201309UV02) {
//            // Find correlations
//            return processFindCorrelations();
//        } else if (requestPayload instanceof PRPAIN201305UV02) {
//            // Patient search
//            return processPatientSearch((PRPAIN201305UV02) requestPayload);
//        } else {
//            // Unknown request
//            return null;
//        }
//    }
//
//    private PRPAIN201310UV02 processFindCorrelations() {
//        PRPAIN201310UV02 mviResponse = new PRPAIN201310UV02();
//
//        PRPAIN201310UV02MFMIMT700711UV01ControlActProcess ca = new PRPAIN201310UV02MFMIMT700711UV01ControlActProcess();
//        mviResponse.setControlActProcess(ca);
//
//        return mviResponse;
//    }
//
//    private PRPAIN201306UV02 processPatientSearch(PRPAIN201305UV02 mviSearchRequest) {
//        PRPAIN201306UV02 mviResponse = new PRPAIN201306UV02();
//
//        PatientProfile patintProfile = null;
//        String firstName = "";
//        String lastName = "";
//
//        // Get the parameter list to see what kind of search we're conducting
//        PRPAMT201306UV02ParameterList parameterList = mviSearchRequest.getControlActProcess().getQueryByParameter().getValue().getParameterList();
//
//        if (parameterList.getId() != null && parameterList.getId().getExtension() != null && !parameterList.getId().getExtension().isEmpty()) {
//            // We are searching by patient ICN
//
//            String icn = parameterList.getId().getExtension().substring(0, parameterList.getId().getExtension().indexOf("^"));
//            patintProfile = patientProfileDao.getByIEN(icn);
//        } else {
//            // We are searching by patient name and SSN
//
//            // Extract first name and last name
//            for (PRPAMT201306UV02LivingSubjectName livingSubjectName : parameterList.getLivingSubjectName()) {
//                for (ENExplicit names : livingSubjectName.getValue()) {
//                    for (Serializable name : names.getContent()) {
//                        if (firstName.length() == 0) {
//                            try {
//                                firstName = ((JAXBElement<EnExplicitGiven>) name).getValue().getContent();
//                            } catch (Exception e) {
//                                // Ignore
//                            }
//                        }
//                        if (lastName.length() == 0) {
//                            try {
//                                lastName = ((JAXBElement<EnExplicitFamily>) name).getValue().getContent();
//                            } catch (Exception e) {
//                                // Ignore
//                            }
//                        }
//                    }
//                }
//            }
//
//            // Extract SSN
//            String ssn = parameterList.getLivingSubjectId().get(0).getValue().get(0).getExtension();
//
//            Collection<PatientProfile> patients = patientProfileDao.findBySSNFirstNameLastName(ssn, lastName, firstName);
//
//            if (patients == null || patients.isEmpty()) {
//                // No matching patient in our DB
//                return mviResponse;
//            }
//
//            // We're assuming single match is found
//            patintProfile = patients.iterator().next();
//        }
//
//        // Start populating the response object
//        PRPAIN201306UV02MFMIMT700711UV01ControlActProcess ca = new PRPAIN201306UV02MFMIMT700711UV01ControlActProcess();
//
//        mviResponse.setControlActProcess(ca);
//
//        List<PRPAIN201306UV02MFMIMT700711UV01Subject1> subjects = ca.getSubject();
//
//        PRPAIN201306UV02MFMIMT700711UV01Subject1 subject = new PRPAIN201306UV02MFMIMT700711UV01Subject1();
//        subjects.add(subject);
//
//        PRPAIN201306UV02MFMIMT700711UV01RegistrationEvent re = new PRPAIN201306UV02MFMIMT700711UV01RegistrationEvent();
//        subject.setRegistrationEvent(re);
//
//        PRPAIN201306UV02MFMIMT700711UV01Subject2 subject2 = new PRPAIN201306UV02MFMIMT700711UV01Subject2();
//        re.setSubject1(subject2);
//
//        PRPAMT201310UV02Patient patient = new PRPAMT201310UV02Patient();
//        subject2.setPatient(patient);
//
//        II id = new II();
//        id.setRoot(VA_OID);
//        id.setExtension(patintProfile.getIEN());
//        patient.getId().add(id);
//
//        ObjectFactory factory = new ObjectFactory();
//        PRPAMT201310UV02Person person = new PRPAMT201310UV02Person();
//        JAXBElement<PRPAMT201310UV02Person> jaxbPerson = factory.createPRPAMT201310UV02PatientPatientPerson(person);
//        patient.setPatientPerson(jaxbPerson);
//
//        // Populate name
//        PNExplicit name = new PNExplicit();
//        name.getUse().add("L");
//
//        // First name
//        EnExplicitGiven firstNameEn = new EnExplicitGiven();
//        firstNameEn.setContent(patintProfile.getFirstName());
//        JAXBElement<EnExplicitGiven> jaxbFirstName = factory.createENExplicitGiven(firstNameEn);
//        name.getContent().add(jaxbFirstName);
//
//        // Middle name
//        EnExplicitGiven middleNameEn = new EnExplicitGiven();
//        middleNameEn.setContent(patintProfile.getMiddleInitial());
//        JAXBElement<EnExplicitGiven> jaxbMiddleName = factory.createENExplicitGiven(middleNameEn);
//        name.getContent().add(jaxbMiddleName);
//
//        // Last name
//        EnExplicitFamily lastNameEn = new EnExplicitFamily();
//        lastNameEn.setContent(patintProfile.getLastName());
//        JAXBElement<EnExplicitFamily> jaxbLastName = factory.createENExplicitFamily(lastNameEn);
//        name.getContent().add(jaxbLastName);
//
//        person.getName().add(name);
//
//        // Populate gender
//        CE gender = new CE();
//        gender.setCode(patintProfile.getGender());
//        person.setAdministrativeGenderCode(gender);
//
//        // Populate SSN
//        PRPAMT201310UV02OtherIDs ssnObj = new PRPAMT201310UV02OtherIDs();
//        ssnObj.getClassCode().add("SSN");
//        CS statusCode = new CS();
//        statusCode.setCode(patintProfile.getSSN());
//        ssnObj.setStatusCode(statusCode);
//        person.getAsOtherIDs().add(ssnObj);
//
//        return mviResponse;
//    }
//
//}
