package gov.va.nvap.mock.endpoint.esr;

import gov.va.med.esr.webservices.jaxws.schemas.DemographicInfo;
import gov.va.med.esr.webservices.jaxws.schemas.EeSummary;
import gov.va.med.esr.webservices.jaxws.schemas.GetEESummaryRequest;
import gov.va.med.esr.webservices.jaxws.schemas.GetEESummaryResponse;
import gov.va.med.esr.webservices.jaxws.schemas.ObjectFactory;
import gov.va.nvap.service.esr.EnrollmentService;

public class MockESRServiceEndpoint implements EnrollmentService {

	@Override
	public GetEESummaryResponse getEESummaryRequest(
			final GetEESummaryRequest request) {
		final ObjectFactory objFactory = new ObjectFactory();
		final GetEESummaryResponse response = objFactory
				.createGetEESummaryResponse();
		final EeSummary eeSummary = objFactory.createEeSummary();
		response.setSummary(eeSummary);
		final DemographicInfo demographicInfo = objFactory
				.createDemographicInfo();
		eeSummary.setDemographics(demographicInfo);
		System.out.println("MOCK");
		demographicInfo.setPreferredFacility("998 - VA Facility 1");
		return response;
	}

}
