package gov.va.nvap.mock.endpoint.adapter.audit;

import gov.va.med.nhin.adapter.audit.ActionType;
import gov.va.med.nhin.adapter.audit.AuditSummariesType;
import gov.va.med.nhin.adapter.audit.AuditSummaryType;
import gov.va.med.nhin.adapter.audit.AuditType;
import gov.va.med.nhin.adapter.audit.AuditsType;
import gov.va.med.nhin.adapter.audit.FieldType;
import gov.va.med.nhin.adapter.audit.GetAudits;
import gov.va.med.nhin.adapter.audit.GetAuditsResponse;
import gov.va.med.nhin.adapter.audit.GetAuditsSummary;
import gov.va.med.nhin.adapter.audit.GetAuditsSummaryResponse;
import gov.va.med.nhin.adapter.audit.PageInfoType;
import gov.va.med.nhin.adapter.audit.SortDirection;
import gov.va.med.nhin.adapter.audit.SortFieldType;
import gov.va.med.nhin.adapter.audit.SortFieldsType;
import gov.va.med.nhin.adapter.audit.SummaryFieldsType;
import gov.va.nvap.common.date.GregorianDateUtil;
import gov.va.nvap.common.validation.NullChecker;

import java.security.SecureRandom;
import java.sql.Timestamp;
import java.util.Arrays;

import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Random;
//import java.util.Random;

import org.springframework.ws.client.core.WebServiceTemplate;

public class MockAuditWebServiceTemplate extends WebServiceTemplate {

	private static int i = 0;
	private final Calendar dateCal = Calendar.getInstance();
        private final List<String> firstNames;
        private final List<String> middleNames;
        private final List<String> lastNames;
        private final List<String> SSNs;
         private final List<String> ICNs;
         
	public MockAuditWebServiceTemplate() {
		this.dateCal.set(1980, 12, 1);
                //each of thse lists must have entries matching across all lists or patient records indices won't line up,
                //maybe should refactor to have some sort of MockPatient class that contains relevant info
                firstNames = Arrays.asList("CHDRONE", "NWHINONE","MOCKFIRST");
                lastNames = Arrays.asList("ZZZCHDRPATIENTONE", "NWHINZZZTESTPATIENT","MOCKLAST");
                middleNames = Arrays.asList("ALLEN", "EDWARD","MOCKMIDDLE");
                SSNs = Arrays.asList("000004444","666100001","222000000");
                ICNs = Arrays.asList("1012581676V377802","1012638924V546709","1012638924V00000");
	}

	@Override
	public void afterPropertiesSet() {
	}

	private void createSummaryResponse(
			final GetAuditsSummaryResponse getAuditsSummaryResponseJunk,
			final ActionType actionType) {

		final AuditSummariesType auditSummariesTypeJunk = new AuditSummariesType();
		final List<AuditSummaryType> AuditSummaryTypeListJunk = auditSummariesTypeJunk
				.getAuditSummary();

		final AuditSummaryType auditSummaryTypeJunk1 = new AuditSummaryType();
		final SummaryFieldsType summaryFieldsType = new SummaryFieldsType();
		final List<String> fieldSet1 = summaryFieldsType.getSummaryField();

		if (actionType.compareTo(ActionType.RETRIEVE_DOCUMENT_OUT) == 0) {
			auditSummaryTypeJunk1.setCount(11);
			fieldSet1.add("urn:oid:2.16.840.1.113883.3.424");
			fieldSet1.add("983");
			fieldSet1.add("Some VA Facility Name");
			fieldSet1.add("Some Organization Name");
		} else {
			auditSummaryTypeJunk1.setCount(25);
			fieldSet1.add("urn:oid:1.3.6.1.4.1.26580");
			fieldSet1.add("998");
			fieldSet1.add("Some VA Facility Name");
			fieldSet1.add("Another Organization Name");
		}
        fieldSet1.add("junk");
        fieldSet1.add("junk");
        fieldSet1.add("junk");
        fieldSet1.add("junk");
        fieldSet1.add("junk");
        fieldSet1.add("junk");
        
		auditSummaryTypeJunk1.setSummaryFields(summaryFieldsType);
		AuditSummaryTypeListJunk.add(auditSummaryTypeJunk1);
		final AuditSummaryType auditSummaryTypeJunk2 = new AuditSummaryType();
		final SummaryFieldsType summaryFieldsType2 = new SummaryFieldsType();
		final List<String> fieldSet2 = summaryFieldsType2.getSummaryField();

		if (actionType.compareTo(ActionType.RETRIEVE_DOCUMENT_OUT) == 0) {
			auditSummaryTypeJunk2.setCount(12);
			fieldSet2.add("urn:oid:2.16.840.1.113883.3.715");
			fieldSet2.add("999");
			fieldSet2.add("Some VA Facility Name");
			fieldSet2.add("Some Organization Name");
		} else {
			auditSummaryTypeJunk2.setCount(28);
			fieldSet2.add("urn:oid:2.16.840.1.113883.3.42.10001.100001.12");
			fieldSet2.add("999");
			fieldSet2.add("Another VA Facility Name");
			fieldSet2.add("Another Organization Name");
		}
        fieldSet2.add("junk");
        fieldSet2.add("junk");
        fieldSet2.add("junk");
        fieldSet2.add("junk");
        fieldSet2.add("junk");
        fieldSet2.add("junk");

		auditSummaryTypeJunk2.setSummaryFields(summaryFieldsType2);

		AuditSummaryTypeListJunk.add(auditSummaryTypeJunk2);
		getAuditsSummaryResponseJunk.setAuditSummaries(auditSummariesTypeJunk);
	}

    /**
     * Filters mock data by test patient SSN, first name and last name.
     * 
     * @param requestPayload Payload received by mock service
     * @return true if test patient meets filtering criteria,
     *          false otherwise
     */
    private boolean filterAuditType(GetAudits requestPayload) {
        
        boolean match;
        if (requestPayload.getPatientSSNs()!= null) {
            match = false;
            for (String item : requestPayload.getPatientSSNs().getValue()) {
                if (SSNs.contains(item)) {
                    match = true;
                    break;
                }
            }
            if (!match) {
                return false;
            }
        }
        if (requestPayload.getPatientGivenNames() != null) {
            match = false;
            for (String item : requestPayload.getPatientGivenNames().getValue()) {
                if (firstNames.contains(item.toUpperCase())) {
                    match = true;
                    break;
                }
            }
            if (!match) {
                return false;
            }
        }
        if (requestPayload.getPatientLastNames() != null) {
            match = false;
            for (String item : requestPayload.getPatientLastNames().getValue()) {
                if (lastNames.contains(item.toUpperCase())) {
                    match = true;
                    break;
                }
            }
            if (!match) {
                return false;
            }            
        }
        return true;
    }
    
	private AuditType getAuditType(final GetAudits audits, int patient) {
		final AuditType auditType = new AuditType();
                SecureRandom rand = new SecureRandom();
                int actionType = rand.nextInt(audits.getActions().getValue().size());
		auditType.setAction(audits.getActions().getValue().get(actionType));
		auditType.setAuditId(new SecureRandom().nextLong());
		this.dateCal.add(Calendar.MONTH, 1);
        auditType.setAuditTime(GregorianDateUtil.getGregorianCalendarByDate(getRandomDateTime()));
		auditType.setDocumentId(Long.toString(MockAuditWebServiceTemplate.i));
		MockAuditWebServiceTemplate.i++;
		if (audits.getActions().getValue().get(0).equals(ActionType.RETRIEVE_DOCUMENT)) {
                    auditType.setOrganizationId("2.16.840.1.113883.3.42.10001.100001.12");
		} else {
                    auditType.setOrganizationId("2.16.840.1.113883.4.349");
		}
                if(patient > firstNames.size() - 1 || patient > middleNames.size() - 1 || patient > lastNames.size() - 1 || patient > SSNs.size() - 1 || patient > ICNs.size() - 1) {
                    auditType.setPatientId("1012581676V377802");
                    auditType.setPatientSSN("000004444");
                    auditType.setPatientLastName("ZZZCHDRPATIENTONE");
                    auditType.setPatientMiddleName("ALLEN");
                    auditType.setPatientGivenName("CHDRONE");
                }
                else {
                    auditType.setPatientId(ICNs.get(patient));
                    auditType.setPatientSSN(SSNs.get(patient));
                    auditType.setPatientLastName(lastNames.get(patient));
                    auditType.setPatientMiddleName(middleNames.get(patient));
                    auditType.setPatientGivenName(firstNames.get(patient));
                }
		auditType.setPurposeForUse("TREATMENT");
		auditType.setRemoteDocumentId(Long.toString(MockAuditWebServiceTemplate.i));
		auditType.setPatientFacilityName("PAT_PREF_FAC");
        auditType.setPatientFacilityNumber("528");
		MockAuditWebServiceTemplate.i++;
		auditType.setRemoteDocumentRepositoryId("0");
		auditType.setDocumentTitle("Continuity of Care Document");
        int rnd = rand.nextInt(4);
        switch (rnd) {
            case 0:
                auditType.setRemoteOrganizationId("urn:oid:2.16.840.1.113883.3.42.10001.100001.12"); // DoD
                break;
            case 1:
                auditType.setRemoteOrganizationId("urn:oid:1.3.6.1.4.1.26580"); // Keiser
                break;
            case 2:
                auditType.setRemoteOrganizationId("urn:oid:1.3.6.1.4.1.37619"); // South Carolina Health
                break;
            default:
                auditType.setRemoteOrganizationId("urn:oid:1.2.3.4.5"); // Unknown
                break;            
        }
		
		auditType.setUserId("528:vacojsmith,CN=John Smith");
                switch(actionType) {
                    case 0: //announce
                        auditType.setDetails("SSN=" + auditType.getPatientSSN() + ",LASTNAME=" + auditType.getPatientLastName() + ",MIDDLENAME=" + auditType.getPatientMiddleName() + "\n" +
                                             ",GIVENNAME=" + auditType.getPatientGivenName() + ",PREFIX=NULL,SUFFIX=NULL,DOB=19600101" + "\n" + 
                                             "ADDRESS=123 FAKE ST,CITY=FAKE CITY,STATE=VA,ZIP=12345,PHONE=" + "\n" +
                                             "(555)555-5555,GENDER=M,MULTIBIRTH=FALSE,MARITALSTATUS=NULL," + "\n" +
                                             "PATIENTID=" + auditType.getPatientId() + "\n" +
                                             ",HOMECOMMUNITYID=" + auditType.getOrganizationId());
                        break;
                    case 1: //check policy
                        String inOut = "OUT";
                        if(auditType.getOrganizationId().equals("2.16.840.1.113883.4.349")) { inOut = "IN"; } 
                        auditType.setDetails("PERMIT PATIENTDISCOVERY" + inOut + " REMOTE" + "\n" +
                                             "FACILITY=URN:OID:" + auditType.getOrganizationId() + " ICN=" + auditType.getPatientId() + ",");
                        break;
                    case 2: //mpi find match
                         if(new SecureRandom().nextInt(2) == 1) {
                            auditType.setDetails("MATCH FOUND ICN=" + auditType.getPatientId() + " REMOTE FACILITY=" + auditType.getOrganizationId() + "\n" + 
                                                 "SSN=" + auditType.getPatientSSN() + ",LASTNAME=" + auditType.getPatientLastName() + ",FIRSTNAME=" + auditType.getPatientGivenName() + "\n" + 
                                                 ",MIDDLENAME=" + auditType.getPatientMiddleName() + ",GENDER=M,DOB=1981-01-01 00:00:00.0," + "\n" +
                                                 "MOTHERSMAIDENNAME=,STREET=,CITY=,STATE=,ZIP=,PHONENUMBER=,POBCITY=,POBSTATE=,");
                        }
                        else {
                            auditType.setDetails("MATCH FAILED ICN=" + auditType.getPatientId() + " REMOTE FACILITY=" + auditType.getOrganizationId() + "\n" + 
                                                 "SSN=" + auditType.getPatientSSN() + ",LASTNAME=" + auditType.getPatientLastName() + ",FIRSTNAME=" + auditType.getPatientGivenName() + "\n" + 
                                                 ",MIDDLENAME=" + auditType.getPatientMiddleName() + ",GENDER=M,DOB=1981-01-01 00:00:00.0," + "\n" +
                                                 "MOTHERSMAIDENNAME=,STREET=,CITY=,STATE=,ZIP=,PHONENUMBER=,POBCITY=,POBSTATE=,");
                        }
                        break;
                    case 3: //add patient correlation
                        auditType.setDetails("CORRELATION ALREADY EXISTS, ICN=" + auditType.getPatientId());
                        break;
                    default:
                        auditType.setDetails("MPI Detail - 2.16.840.1.113883.3.42.10001.100001.12 2.16.840.1.113883.3.42.10001.100001.12 2.16.840.1.113883.3.42.10001.100001.12 2.16.840.1.113883.3.42.10001.100001.12 Test Match 2.16.840.1.113883.3.42.10001.100001.12 2.16.840.1.113883.3.42.10001.100001.12");
                        break;
                }
		return auditType;
	}

	@Override
	protected void initDefaultStrategies() {
	}

	@Override
	public Object marshalSendAndReceive(final Object requestPayload) {
		if (requestPayload instanceof GetAudits) {
                    final GetAudits audits = (GetAudits) requestPayload;
                    final GetAuditsResponse response = new GetAuditsResponse();
                    final AuditsType auditsType = new AuditsType();
                    AuditType auditType;
                    int totalSize = 900 + (new Random()).nextInt(200);
                    if ( audits.getPageInfo()!= null && audits.getPageInfo().getPageSize() > 0) {
                            //add random patient audit from mock patients for each record on page
                            for (int i = 0; i < audits.getPageInfo().getPageSize(); i++) {
                                auditType = this.getAuditType(audits, new SecureRandom().nextInt(SSNs.size()));
                                if (filterAuditType((GetAudits)requestPayload)) {
                                    auditsType.getAudit().add(auditType);
                                }
                            }
                            audits.getPageInfo().setTotalSize(totalSize);
                            response.setPageInfo(audits.getPageInfo());
                    } 
                    else {
                        //add totalSize random patient audit from mock patients 
                        int size = totalSize;
                        for (int i = 0; i < size; i++) {
                            auditsType.getAudit().add(this.getAuditType(audits, new SecureRandom().nextInt(SSNs.size())));
                        }
                    }
                    //deal with sorting
                    SortFieldsType sortFields = audits.getSortFields();
                    if(!NullChecker.isNullOrEmpty(sortFields)) {
                        for(SortFieldType sortField : sortFields.getSortField()) {
                            final FieldType field = sortField.getField();
                            final SortDirection direction = sortField.getDirection();
                            Collections.sort(auditsType.getAudit(), new Comparator<AuditType>() { 
                                @Override
                                public int compare(AuditType o1, AuditType o2) {
                                    int sortModifier = 1;
                                    try {
                                        if(direction.value().equals("DESC")) { sortModifier = -1; }
                                        if(field.value().equals("patientSSN")) {
                                            return sortModifier * o1.getPatientSSN().compareTo(o2.getPatientSSN());
                                        }
                                        else if(field.value().equals("auditTime")) {
                                            return sortModifier * o1.getAuditTime().toGregorianCalendar().compareTo(o2.getAuditTime().toGregorianCalendar());
                                        }
                                        else if(field.value().equals("patientLastName")) {
                                            return sortModifier * o1.getPatientLastName().compareTo(o2.getPatientLastName());
                                        }
                                        else if(field.value().equals("patientGivenName")) {
                                            return sortModifier * o1.getPatientGivenName().compareTo(o2.getPatientGivenName());
                                        }
                                        else if(field.value().equals("patientMiddleName")) {
                                            return sortModifier * o1.getPatientMiddleName().compareTo(o2.getPatientMiddleName());
                                        }
                                        else if(field.value().equals("organizationName")) {
                                            return sortModifier * o1.getOrganizationName().compareTo(o2.getOrganizationName());
                                        }
                                        else if(field.value().equals("purposeForUse")) {
                                            return sortModifier * o1.getPurposeForUse().compareTo(o2.getPurposeForUse());
                                        }
                                        else if(field.value().equals("remoteOrganizationName")) {
                                            return sortModifier * o1.getRemoteOrganizationName().compareTo(o2.getRemoteOrganizationName());
                                        }
                                        else if(field.value().equals("action")) {
                                            return sortModifier * o1.getAction().value().compareTo(o2.getAction().value());
                                        }
                                        else if(field.value().equals("details")) {
                                            return sortModifier * o1.getDetails().compareTo(o2.getDetails());
                                        }
                                    }
                                    //with mock services, currently don't do any comparison with null values
                                    //TODO: do something better with comparing null values to better mimic real response
                                    catch(NullPointerException npe) {
                                        return sortModifier;
                                    }
                                    return sortModifier;
                                }

                            });
                        }
                    }
                    response.setAudits(auditsType);
                    return response;
		} else {
			final GetAuditsSummaryResponse getAuditsSummaryResponseJunk = new GetAuditsSummaryResponse();
			this.createSummaryResponse(getAuditsSummaryResponseJunk,
					((GetAuditsSummary) requestPayload).getActions().getValue()
							.get(0));
			return getAuditsSummaryResponseJunk;
		}

	}
    
    private Timestamp getRandomDateTime() {
        long offset = Timestamp.valueOf("2012-01-01 00:00:00").getTime();
        long end = Timestamp.valueOf("2016-12-31 23:59:00").getTime();
        long diff = end - offset + 1;
        Timestamp rand = new Timestamp(offset + (long)(Math.random() * diff));
        
        return rand;
    }
}
