package gov.va.nvap.mock.endpoint.adapter.announce;

import gov.va.med.nhin.adapter.announce.AnnouncePatient;
import gov.va.med.nhin.adapter.announce.AnnouncePatientResponse;
import gov.va.nvap.common.transformer.TransformerException;
import gov.va.nvap.common.transformer.xml.XMLToString;

import java.io.IOException;

import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.oxm.Marshaller;
import org.springframework.ws.client.core.WebServiceTemplate;

public class MockPatientAnnouncerWebServiceTemplate extends WebServiceTemplate {

	private static final Log LOG = LogFactory
			.getLog(MockPatientAnnouncerWebServiceTemplate.class);

	@Override
	public Object marshalSendAndReceive(final Object requestPayload) {

		// if (LOG.isInfoEnabled()) {
		try {
			final Result result = new DOMResult();
			final Marshaller marshaller = this.getMarshaller();
			marshaller.marshal(requestPayload, result);
			final String request = new XMLToString()
					.transform((org.w3c.dom.Document) ((DOMResult) result)
							.getNode());
			MockPatientAnnouncerWebServiceTemplate.LOG.info(request);
		} catch (final TransformerException ex) {
			throw new RuntimeException(ex);
		} catch (final IOException ex) {
			throw new RuntimeException(ex);
		}
		// }
		final AnnouncePatient request = (AnnouncePatient) requestPayload;
		final AnnouncePatientResponse response = new AnnouncePatientResponse();
		response.setReturn(-1);
		// int i = 0;
		// if (i == 1) {
		// throw new RuntimeException("Some Error");
		// }
		if (MockPatientAnnouncerWebServiceTemplate.LOG.isInfoEnabled()) {

			//MockPatientAnnouncerWebServiceTemplate.LOG
			//		.info("Announced ICN:" + request.getPatientId() + " to "
			//				+ request.getFacilities());
		}
		return response;
	}
}
