package gov.va.nvap.mock.endpoint.adapter;

import gov.hhs.fha.nhinc.common.nhinccommonadapter.RespondingGatewayCrossGatewayRetrieveRequest;
import gov.va.nvap.common.file.FileUtil;
import gov.va.nvap.common.transformer.TransformerException;
import gov.va.nvap.common.transformer.xml.XMLToString;
import gov.va.nvap.common.validation.NullChecker;
import ihe.iti.xds_b._2007.RetrieveDocumentSetRequestType.DocumentRequest;
import ihe.iti.xds_b._2007.RetrieveDocumentSetResponse;
import ihe.iti.xds_b._2007.RetrieveDocumentSetResponseType.DocumentResponse;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.oxm.Marshaller;
import org.springframework.ws.client.core.WebServiceTemplate;
import org.springframework.ws.transport.WebServiceMessageSender;

public class MockAdapterDocRetrievePortImpl extends WebServiceTemplate {

	private static final Log LOG = LogFactory
			.getLog(MockAdapterDocRetrievePortImpl.class);

	@Autowired
	ApplicationContext applicationContext;

	private int randomC32Count = 0;
	List<String> randomC32s;
	private int randomDocCount = 0;
	List<String> randomDocs;

	public MockAdapterDocRetrievePortImpl() {
	}

	@Override
	public void afterPropertiesSet() {

	}

	@Override
	protected void initDefaultStrategies() {
	}

	@Override
	public Object marshalSendAndReceive(final Object requestPayload) {
		if (MockAdapterDocRetrievePortImpl.LOG.isInfoEnabled()) {
			try {
				final Result result = new DOMResult();
				final Marshaller marshaller = this.getMarshaller();
				marshaller.marshal(requestPayload, result);
				final String request = new XMLToString()
						.transform((org.w3c.dom.Document) ((DOMResult) result)
								.getNode());
				MockAdapterDocRetrievePortImpl.LOG.info(request);
			} catch (final TransformerException ex) {
				throw new RuntimeException(ex);
			} catch (final IOException ex) {
				throw new RuntimeException(ex);
			}
		}

		return this
				.respondingGatewayCrossGatewayRetrieve((RespondingGatewayCrossGatewayRetrieveRequest) requestPayload);
	}

	public RetrieveDocumentSetResponse respondingGatewayCrossGatewayRetrieve(
			final RespondingGatewayCrossGatewayRetrieveRequest respondingGatewayCrossGatewayRetrieveRequest) {
		final DocumentResponse documentResponse = new DocumentResponse();
		final DocumentRequest request = respondingGatewayCrossGatewayRetrieveRequest
				.getRetrieveDocumentSetRequest().getDocumentRequest().get(0);
		String responseDoc = "";
		if (NullChecker.isNotEmpty(request.getDocumentUniqueId())) {
			if (this.randomDocs.size() > this.randomDocCount) {
				responseDoc = this.randomDocs.get(this.randomDocCount);
			} else {
				this.randomDocCount = 0;
				responseDoc = this.randomDocs.get(this.randomDocCount);
			}
			this.randomDocCount++;
		} else {
			if (this.randomC32s.size() > this.randomC32Count) {
				responseDoc = this.randomC32s.get(this.randomC32Count);
			} else {
				this.randomC32Count = 0;
				responseDoc = this.randomC32s.get(this.randomC32Count);
			}
			this.randomC32Count++;
		}
		documentResponse.setDocument(responseDoc.getBytes());
		final RetrieveDocumentSetResponse retrieveDocumentSetResponse = new RetrieveDocumentSetResponse();
		retrieveDocumentSetResponse.getDocumentResponse().add(documentResponse);
		return retrieveDocumentSetResponse;
	}

	public String returnC32Response() throws IOException {
		final org.springframework.core.io.Resource resource = this.applicationContext
				.getResource("classpath:gov/va/nvap/mock/endpoint/adapter/doc/Utah 2011 03 05 CCD.XML");
		final String utahC32 = FileUtil.getResource(resource);
		return utahC32;
	}

	public String returnC62Response() throws IOException {
		final org.springframework.core.io.Resource resource = this.applicationContext
				.getResource("classpath:gov/va/nvap/mock/endpoint/adapter/report/Joseph Nhinpatient XDS-SD.xml");
		final String josephC62 = FileUtil.getResource(resource);
		return josephC62;
	}

	public void setRandomC32s(final List<Resource> randomFiles)
			throws IOException {
		this.randomC32s = new ArrayList<String>();
		for (final Resource res : randomFiles) {
			final String someFile = FileUtil.getResource(res);
			this.randomC32s.add(someFile);
		}
	}

	public void setRandomFiles(final List<Resource> randomFiles)
			throws IOException {
		this.randomDocs = new ArrayList<String>();
		for (final Resource res : randomFiles) {
			final String someFile = FileUtil.getResource(res);
			this.randomDocs.add(someFile);
		}
	}

	@Override
	public void setMessageSender(WebServiceMessageSender messageSender) {
		// TODO Auto-generated method stub
		super.setMessageSender(messageSender);
	}
}
