/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.nvap.mock.endpoint.adapter;

import java.io.Serializable;
import java.util.Date;

public class Document implements Serializable {
	/**
	 * 
	 */
	private static final long serialVersionUID = 3536047695910192199L;
	private Date beginDate;
	private String classCode;
	private String classCodeDisplayName;
	private String classCodeScheme;
	private Date creationTime;
	private Long documentId;
	private String documentUniqueId;
	private Date endDate;
	private String hash;
	private Date lastAccessedTime;
	private String mimeType;
	private String patientId;
	private byte[] rawData;
	private Integer size;
	private String title;

	public Document() {
	}

	@Override
	public boolean equals(final Object obj) {
		if (!(obj instanceof Document)) {
			return false;
		}
		final Document doc = (Document) obj;
		if ((this != doc)
				&& ((this.documentId == null) || (doc.documentId == null) || !this.documentId
						.equals(doc.documentId))) {
			return false;
		}
		return true;
	}

	public Date getBeginDate() {
		return this.beginDate;
	}

	public String getClassCode() {
		return this.classCode;
	}

	public String getClassCodeDisplayName() {
		return this.classCodeDisplayName;
	}

	public String getClassCodeScheme() {
		return this.classCodeScheme;
	}

	public Date getCreationTime() {
		return this.creationTime;
	}

	public Long getDocumentId() {
		return this.documentId;
	}

	public String getDocumentUniqueId() {
		return this.documentUniqueId;
	}

	public Date getEndDate() {
		return this.endDate;
	}

	public String getHash() {
		return this.hash;
	}

	public Date getLastAccessedTime() {
		return this.lastAccessedTime;
	}

	public String getMimeType() {
		return this.mimeType;
	}

	public String getPatientId() {
		return this.patientId;
	}

	public byte[] getRawData() {
		return this.rawData;
	}

	public Integer getSize() {
		return this.size;
	}

	public String getTitle() {
		return this.title;
	}

	@Override
	public int hashCode() {
		int ret = 0;
		ret += (this.documentId != null ? this.documentId.hashCode() : 0);
		return ret;
	}

	public void setBeginDate(final Date beginDate) {
		this.beginDate = beginDate;
	}

	public void setClassCode(final String classCode) {
		this.classCode = classCode;
	}

	public void setClassCodeDisplayName(final String classCodeDisplayName) {
		this.classCodeDisplayName = classCodeDisplayName;
	}

	public void setClassCodeScheme(final String classCodeScheme) {
		this.classCodeScheme = classCodeScheme;
	}

	public void setCreationTime(final Date creationTime) {
		this.creationTime = creationTime;
	}

	public void setDocumentId(final Long documentId) {
		this.documentId = documentId;
	}

	public void setDocumentUniqueId(final String documentUniqueId) {
		this.documentUniqueId = documentUniqueId;
	}

	public void setEndDate(final Date endDate) {
		this.endDate = endDate;
	}

	public void setHash(final String hash) {
		this.hash = hash;
	}

	public void setLastAccessedTime(final Date lastAccessedTime) {
		this.lastAccessedTime = lastAccessedTime;
	}

	public void setMimeType(final String mimeType) {
		this.mimeType = mimeType;
	}

	public void setPatientId(final String patientId) {
		this.patientId = patientId;
	}

	public void setRawData(final byte[] rawData) {
		this.rawData = rawData;
	}

	public void setSize(final Integer size) {
		this.size = size;
	}

	public void setTitle(final String title) {
		this.title = title;
	}
}
