package gov.va.nvap.mock.dao;

/**
 *
 * @author Johann Sonnenberg
 */

import gov.va.nvap.common.file.FileUtil;
import gov.va.nvap.mock.endpoint.mvi.PatientProfile;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;

public class PatientProfileDAO {

    /**
     * Entity Manager instance.
     */
    @PersistenceContext 
    private EntityManager em;
    
    @Autowired
	ApplicationContext applicationContext;
    
    /**
     * Set the entity manager (Injected by Spring).
     * @param em
     */
    public void setEntityManager(final EntityManager em) {
            this.em = em;
    }

    @SuppressWarnings("unchecked")
    public Collection<PatientProfile> findBySSNFirstNameLastName( String ssn, String lastName, String firstName ) {
            Query query = em.createQuery("SELECT p FROM PatientProfile p WHERE p.ssn = :ssn AND lower(p.lastName) = lower(:lastName) AND lower(p.firstName) = lower(:firstName)");
            query.setParameter("ssn", ssn);
            query.setParameter("lastName", lastName);
            query.setParameter("firstName", firstName);
            
        return (Collection<PatientProfile>) query.getResultList();
    }

    @SuppressWarnings("unchecked")
    public PatientProfile getByIEN( String ien ) {
            Query query = em.createQuery("SELECT p FROM PatientProfile p WHERE p.ien = :ien");
            query.setParameter("ien", ien);
        return (PatientProfile) query.getResultList().get(0);
    }

    @SuppressWarnings("unchecked")
    public String getPayload( String ssn, String lastName, String firstName ) {
        StringBuilder sb = new StringBuilder();
        int count = 1;
        Collection<PatientProfile> patients = findBySSNFirstNameLastName(ssn, lastName, firstName);
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
        
        try {
            //if we didn't fine a match
            if( patients.isEmpty() ) 
            {
                final Resource resource = this.applicationContext.getResource("classpath:gov/va/nvap/mock/endpoint/mvi/RSP_K22_NoMatches.er7");
                final String rspK22ER7 = FileUtil.getResource(resource);
                return rspK22ER7;
            }
        
            //one match
            if( patients.size() == 1 ) 
            {
                Resource resource = this.applicationContext.getResource("classpath:gov/va/nvap/mock/endpoint/mvi/RSP_K22_SingleMatch_macros.er7");
                String primaryData = FileUtil.getResource(resource);
                PatientProfile p = patients.iterator().next();
                Date date = formatter.parse(p.getDateOfBirth());

                //do the replaces
                primaryData = primaryData.replace("[ien]", p.getIEN());
                primaryData = primaryData.replace("[ssn]", p.getSSN());
                primaryData = primaryData.replace("[lastname]", p.getLastName());
                primaryData = primaryData.replace("[firstname]", p.getFirstName());
                primaryData = primaryData.replace("[middleinitial]", p.getMiddleInitial());
                primaryData = primaryData.replace("[gender]", p.getGender().toUpperCase().substring(0, 1));
                primaryData = primaryData.replace("[dob]", formatter.format(date));

                return primaryData;
            }
            
            //more than one match
            if( patients.size() > 1 ) 
            {
                Resource resource = this.applicationContext.getResource("classpath:gov/va/nvap/mock/endpoint/mvi/RSP_K22_MultipleMatches_macros.er7");
                String moreData = FileUtil.getResource(resource);
                
                //only return two matches as that will satisfy the testing requirement for more than one
                for( PatientProfile pp : patients )
                {
                    if( count > 2 )
                    {
                        break;
                    }
                    
                    Date date = formatter.parse(pp.getDateOfBirth());

                    //do the replaces
                    moreData = moreData.replace("[ien"+count+"]", pp.getIEN());
                    moreData = moreData.replace("[ssn"+count+"]", pp.getSSN());
                    moreData = moreData.replace("[lastname"+count+"]", pp.getLastName());
                    moreData = moreData.replace("[firstname"+count+"]", pp.getFirstName());
                    moreData = moreData.replace("[middleinitial"+count+"]", pp.getMiddleInitial());
                    moreData = moreData.replace("[gender"+count+"]", pp.getGender().toUpperCase().substring(0, 1));
                    moreData = moreData.replace("[dob"+count+"]", formatter.format(date));
                    
                    count++;
                }
                
                return moreData;
            }
        } catch (Exception ex) {
            Logger.getLogger(PatientProfileDAO.class.getName()).log(Level.SEVERE, null, ex);
        }
        
        return sb.toString();
    }
}
