package gov.va.med.vler.nwhin.vap.migration;

import gov.va.med.nhin.vap.pip.data.PatientDocument;
import gov.va.med.nhin.vap.pip.data.PatientDocumentType;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.transaction.annotation.Transactional;

/**
 * Store Patient Document
 * 
 * @author Asha Amritraj
 * 
 */

@Transactional
public class PatientDocumentDAO {

	private static final Log LOG = LogFactory.getLog(PatientDocumentDAO.class);

	@PersistenceContext(name = "nwhin_vap_migration")
	private EntityManager entityManager;

	public void storePatientDocument(final PatientDocument patientDocument,
			final long consentDirectiveId, final int recordNumber,
			final int recordSize) {
		try {
			PatientDocumentType patientDocumentType = patientDocument
					.getPatientDocumentType();
			if (patientDocumentType != null) {
				patientDocumentType = this.entityManager.getReference(
						patientDocumentType.getClass(),
						patientDocumentType.getDocumentTypeId());
				patientDocument.setPatientDocumentType(patientDocumentType);
			}
			this.entityManager.persist(patientDocument);
		} catch (final Exception ex) {
			PatientDocumentDAO.LOG
					.error("Error Occured when Processing Record "
							+ consentDirectiveId + ": " + recordNumber + " of "
							+ +recordSize);
			PatientDocumentDAO.LOG.error("Exception Message: "
					+ ex.getMessage());
			PatientDocumentDAO.LOG.error("Rolling back transaction");
		}
	}

}
