/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.nvap.extsvc.psim.impl;

import gov.va.nvap.common.util.IcnChecksum;
import gov.va.nvap.extsvc.psim.intf.PersonServiceException;
import gov.va.nvap.extsvc.psim.intf.PersonServiceInterface;

import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;

import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

import org.apache.commons.lang.StringEscapeUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.springframework.ws.client.core.WebServiceTemplate;

/**
 * 
 * @author vhaislegberb
 */
public class PersonServiceEndpoint implements PersonServiceInterface {

	private static String GET_CORRESPONDING_IDS = "<m:getCorrespondingIds xmlns:m=\"PSIM\"><vpidstr xsi:type=\"xsd:string\" "
			+ "xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" "
			+ "xmlns:soapenc=\"http://schemas.xmlsoap.org/soap/encoding/\" "
			+ "xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" >%s</vpidstr>"
			+ "</m:getCorrespondingIds>";

	private static String GET_CORRESPONDING_IDS_VPIDSTR = "<IDM_REQUEST type='GET_CORRESPONDING_IDS'><ARGUMENTS><ARGUMENT name='sourceId'>"
			+ "<IDENTIFIER type='NI'><ID>%s</ID><ISSUER>USVHA</ISSUER><SOURCE>200M</SOURCE></IDENTIFIER></ARGUMENT>"
			+ "<ARGUMENT name='statusList'><VALUE>A</VALUE><VALUE>H</VALUE></ARGUMENT></ARGUMENTS></IDM_REQUEST>";

	private WebServiceTemplate psimTemplate;

	@Override
	public List<String> getCorrelatedIds(String vpid) {

		vpid = this.validateAndChecksum(vpid);

		new ArrayList<String>();

		final String vpidString = String.format(
				PersonServiceEndpoint.GET_CORRESPONDING_IDS_VPIDSTR, vpid);
		final String getCorrespondingIdsReq = String.format(
				PersonServiceEndpoint.GET_CORRESPONDING_IDS,
				StringEscapeUtils.escapeHtml(vpidString));

		final StringWriter resultWriter = new StringWriter();
		final StreamSource source = new StreamSource(new StringReader(
				getCorrespondingIdsReq));
		final StreamResult result = new StreamResult(resultWriter);
		this.psimTemplate.sendSourceAndReceiveToResult(source, result);

		return this.getVpidsFromResult(StringEscapeUtils
				.unescapeHtml(resultWriter.getBuffer().toString()));
	}

	private List<String> getVpidsFromResult(final String result) {
		final List<String> vpids = new ArrayList<String>();

		try {

			final Document document = new SAXReader().read(new StringReader(
					result));
			final List<Element> identifiers = document
					.selectNodes("//IDENTIFIER[@type='NI']/ID");

			for (final Element id : identifiers) {
				vpids.add(id.getTextTrim());
			}

			if (vpids.isEmpty()) {
				// try to get the error description from the message
				final Element error = (Element) document
						.selectSingleNode("//ERROR/TEXT");
				final String errorMessage = String
						.format("VAP Person Service Endpoint Error: %s",
								(error != null) ? error.getTextTrim()
										: "Error getting VPIDs from PSIM Service. No error Message returned.");
				throw new PersonServiceException(errorMessage);
			}

		} catch (final DocumentException dex) {
			throw new PersonServiceException("Error processing results.", dex);
		}

		return vpids;
	}

	public void setPsimTemplate(final WebServiceTemplate psimTemplate) {
		this.psimTemplate = psimTemplate;
	}

	protected String validateAndChecksum(String vpid) {
		if (vpid != null) {
			if (vpid.length() == 10) {
				vpid = IcnChecksum.addChecksumToIcn(vpid);
			} else if (vpid.length() != 17) {
				throw new IllegalArgumentException(
						String.format(
								"Invalid ICN '%s'. ICN must have a length of either 10 or 17 characters.",
								vpid));
			}
		}

		return vpid;
	}
}
