package gov.va.nvap.esr.adapter.jee.wrapper;


import gov.va.nvap.esr.adapter.data.ESRAttributes;
import gov.va.nvap.esr.adapter.intf.ESRAdapter;


import javax.ejb.Stateless;
import javax.interceptor.Interceptors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.ejb.interceptor.SpringBeanAutowiringInterceptor;

/**
 * Exposes the ESRAdapterImpl thru a Local Stateless Session Beam. 
 * 
 * @author Anand Sastry
 * 
 */
@Stateless(name = "ESRAdapter", mappedName = "ESRAdapter")
@javax.ejb.Local(ESRAdapter.class)
@Interceptors(SpringBeanAutowiringInterceptor.class)
public class ESRAdapterFacade implements ESRAdapter {

	@Autowired
	@Qualifier(value = "ESRAdapterImpl")
	ESRAdapter esrAdapter;
	
	@Override
	public ESRAttributes getESRAttributes(String patientICN) {
		return this.esrAdapter.getESRAttributes(patientICN);
	}
}
