package gov.va.nvap.esr.adapter.impl;

import org.springframework.beans.factory.annotation.Required;

import gov.va.med.esr.webservices.jaxws.schemas.GetEESummaryRequest;
import gov.va.med.esr.webservices.jaxws.schemas.GetEESummaryResponse;
import gov.va.nvap.esr.adapter.data.ESRAttributes;
import gov.va.nvap.esr.adapter.intf.ESRAdapter;
import gov.va.nvap.service.esr.EnrollmentService;

public class ESRAdapterImpl implements ESRAdapter {

	EnrollmentService enrollmentServiceProxy;
	
	@Override
	public ESRAttributes getESRAttributes(String patientICN) {
		String patientPreferredFacility = "";
		// build Request
		final GetEESummaryRequest request = this.buildRequest(patientICN);
		// invoke service
		final GetEESummaryResponse response = this.invokeWS(request);
		// Get patient's preferred facility
		patientPreferredFacility = this.extractPreferredFacility(response);
		// Populate ESR Attributes
		ESRAttributes esrAttributes = new ESRAttributes();
		esrAttributes.setPatientPreferredFacilityStationNumber(patientPreferredFacility);

		return esrAttributes;
	}
	
	private GetEESummaryRequest buildRequest(final String patientICN) {
		final GetEESummaryRequest request = new GetEESummaryRequest();
		request.setKey(patientICN);
		request.setKeyType("VPID");
		request.setRequestName("preferredFacility");
		return request;
	}

	private String extractPreferredFacility(final GetEESummaryResponse response) {
		String patientPreferredFacility = "";

		if ((response != null) && (response.getSummary() != null)
				&& (response.getSummary().getDemographics() != null)) {
			final String facilityString = response.getSummary()
					.getDemographics().getPreferredFacility();
			if (facilityString == null) {
				return patientPreferredFacility;
			}
			final String[] facilityTokens = facilityString.split("-");
			if ((facilityTokens != null) && (facilityTokens.length == 2)) {
				patientPreferredFacility = facilityTokens[0].trim();
			}
		}
		return patientPreferredFacility;
	}

	private GetEESummaryResponse invokeWS(final GetEESummaryRequest request) {
		final GetEESummaryResponse response = this.enrollmentServiceProxy
				.getEESummaryRequest(request);
		return response;
	}

	@Required
	public void setEnrollmentServiceProxy(final EnrollmentService enrollmentServiceProxy) {
		this.enrollmentServiceProxy = enrollmentServiceProxy;
	}
}
