from java.util import Properties
from java.io import FileInputStream, File

class PropertyHelper :
    
    __domainProps = None
    
    def __init__(self, domainPropsPath ):
        print ""
        print "Initializing domain properties at path: " +domainPropsPath
        print ""
        
        self.__domainProps = Properties();
        fileInputStream = FileInputStream(File(domainPropsPath));
        self.__domainProps.load(fileInputStream);
        
        print ""
        print "Properties initialized successfully."
        print ""
        
        
        
    def getProperties(self):
        return domainProps;
        
    def getAdminServerAttributes(self):
        
        # get the app name
        app = self.getAppName()
        
        # build the admin server base key
        baseKey = app + '.server.admin'
        serverAttribs = {}
        
        # read all properties from the properties object whose key starts with the baseKey value
        for key in self.__domainProps.keys() :
            if key.startswith(baseKey) :
                val = self.__domainProps.getProperty(key);
                key = key.replace(baseKey+'.', '')
                serverAttribs[key] = val
        
        return serverAttribs
    
    def getManagedServers(self):
        return self.__buildMapFromProperties(self.getAppName() + ".server.managed")
    
    def getMachines(self):
        return self.__buildMapFromProperties(self.getAppName() + ".machine")
    
    def getClusters(self):
        return self.__buildMapFromProperties(self.getAppName() + ".cluster")
    
    def getJmsResources(self):
        return self.__buildMapFromProperties(self.getAppName() + ".jms.resource") 
    
    def getConnectionFactories(self):
        return self.__buildMapFromProperties(self.getAppName() + ".jms.connection.factory")
    
    def getQueues(self):
        return self.__buildMapFromProperties(self.getAppName() + ".jms.queue")
    
    def getDatasources(self):
        return self.__buildMapFromProperties(self.getAppName() + ".ds")
    
    def getNodeManagerAttributes(self):
        return self.__buildMapFromProperties(self.getAppName() + ".nm")
    
    def getAppName(self):
        return self.__domainProps.get('app.name')
    
    def getApplicationInfo(self, applicationName):
        key = self.getAppName() + ".application"
        map = self.__buildMapFromProperties(key)
        return map.get(applicationName);
    
    def getDomainName(self):
        app = self.getAppName()
        return self.__domainProps.getProperty(app + '.domain.name');
    
    def getDomainsDirectory(self, machine):
        print "Getting domain directory for machine: " + machine
        propKey = self.getAppName() + ".machine." + machine + ".domainDirectory"
        print "Domain Directory Property Key: " + propKey 
        return self.__domainProps.getProperty(propKey)
    
    def getDomainsDirectoryByMachineName(self, machineName):
        retVal = None
        machines = self.getMachines()
        if(machines != None) :
            for name, m in machines.iteritems() :
                if( m['name'] == machineName) :
                    retVal = self.getDomainsDirectory(name)
        return retVal
    
    def getOverwriteRootDir(self):
        print domainProps
        app = getAppName()
        return self.__domainProps.getProperty(app + '.script.overwrite')
    
    def getConnectionTimeout(self):
        app = getAppName()
        return self.__domainProps.getProperty(app + '.script.timeout')
    
    def __buildMapFromProperties(self, baseKey):
        
        map = {}
        
        for key in self.__domainProps.keys() :
            if(key.startswith(baseKey)) :
                val = self.__domainProps.getProperty(key);
                key = key.replace(baseKey+'.', '');
                tuple = key.split('.')
                
                if( map.get(tuple[0]) == None ) : 
                    map.setdefault(tuple[0], {tuple[1]:val}) 
                else :
                    submap = map.get(tuple[0]) 
                    submap[tuple[1]] = val
                
        return map
        