from weblogic.descriptor import BeanAlreadyExistsException
from java.lang.reflect import UndeclaredThrowableException
from java.lang import System, IllegalArgumentException
import javax
from javax import management
from javax.management import MBeanException
from javax.management import RuntimeMBeanException
import javax.management.MBeanException
from java.lang import UnsupportedOperationException
import os
import sys
import wl

def initConfigToScriptRun(domainName, domainDirectory, adminServer, overwrite='true'):
  global startedNewServer
  wl.hideDisplay()
  wl.hideDumpStack("true")

  # try connecting to a running server if it is already running ... 
  if wl.connected=="false":
    try:
      wl.connect(adminServer['username'], adminServer['password'], adminServer['url'])
    except wl.WLSTException:
      print 'No server is running at '+adminServer['url']+', the script will start a new server'
  
  wl.hideDumpStack("false")
  if wl.connected=="false":
    print 'Starting a brand new server at '+adminServer['url']+' with server name '+adminServer['name']
    print 'Please see the server log files for startup messages available at '+domainDirectory
    # If a config.xml exists in the domainDir, WLST will use that config.xml to bring up the server. 
    # If you would like WLST to overwrite this directory, you should specify overWriteRootDir='true' as shown below
    # startServer(adminServerName, domName, URL, userName, passWord,domainDir, overWriteRootDir='true')
    # If you want to specify additional JVM arguments, set them using startServerJvmArgs in the property file or below
    wl.startServer(adminServer['name'], domainName, adminServer['url'], adminServer['username'], adminServer['password'], domainDirectory, timeout=240000, block='true', overWriteRootDir=overwrite, jvmArgs=" -Xms256m -Xmx256m -XX:MaxPermSize=512m")
    startedNewServer=1
    
    print "Started Server. Trying to connect to the server ... "
    wl.connect(adminServer['username'], adminServer['password'], adminServer['url'])
    print 'Connected to server.'
    if wl.connected=='false':
      wl.stopExecution('You need to be connected.')

def startTransaction():
  wl.edit()
  wl.startEdit()

def endTransaction():
  wl.startEdit()
  wl.save()
  wl.activate(block="true")

from javax.management import InstanceAlreadyExistsException
from java.lang import Exception, Class, String
from jarray import array

def endOfConfigToScriptRun():
  global startedNewServer
  #Save the changes you have made
  # shutdown the server you have started
  if startedNewServer==1:
    print 'Shutting down the server that is started... '
    wl.shutdown(force='true', block='true')
  print 'Done executing the script.'

def create_Server(path, beanName, listenPort = "7000", listenAddress = ""):
  wl.cd(path)
  try:
    print "creating mbean of type Server ... "
    serverBean = wl.cmo.lookupServer(beanName)
    if serverBean == None:
        print "createing Server mbean: " + beanName
        serverBean = wl.cmo.createServer(beanName)
      
    # set the properties for the server
    wl.cd(path + "Servers/" + beanName)
    #ls()
    print "setting attributes for mbean type Server"
    wl.set("ListenPort", listenPort)
    wl.set("ListenAddress", listenAddress)

    
  except java.lang.UnsupportedOperationException, usoe:
    pass
  except weblogic.descriptor.BeanAlreadyExistsException,bae:
    pass
  except java.lang.reflect.UndeclaredThrowableException,udt:
    pass

def setManagedServerAttributes(msName, clusterName, machineName):
    print "Setting attributes for managed server: " + msName
    wl.cd("/Servers/" + msName)
    wl.set("JavaCompiler", "javac")
    wl.set("ListenPortEnabled", "true")
    wl.set("ListenAddress", "")
    wl.set("ClientCertProxyEnabled", "false")
    
    if clusterName != None and clusterName != "":
        print "Cluster name = " + clusterName
        bean = wl.getMBean("/Clusters/" + clusterName)
        wl.cmo.setCluster(bean)
    
    if machineName != None and machineName != "":
        bean = wl.getMBean("/Machines/" + machineName)
        wl.cmo.setMachine(bean)

def create_MigratableTarget(path, beanName):
  wl.cd(path)
  try:
    print "creating mbean of type MigratableTarget ... "
    theBean = wl.cmo.lookupMigratableTarget(beanName)
    if theBean == None:
      wl.cmo.createMigratableTarget(beanName)
  except java.lang.UnsupportedOperationException, usoe:
    pass
  except weblogic.descriptor.BeanAlreadyExistsException,bae:
    pass
  except java.lang.reflect.UndeclaredThrowableException,udt:
    pass

def setMigratableTagetAttributesFor(managedServer, clusterName):
  wl.cd("/MigratableTargets/" + managedServer + " (migratable)")
  print "setting attributes for mbean type MigratableTarget " + managedServer
  wl.set("Notes", "This is a system generated default migratable target for a server. Do not delete manually.")
  bean = wl.getMBean("/Clusters/" + clusterName)
  wl.cmo.setCluster(bean)

  bean = wl.getMBean("/Servers/" + managedServer)
  wl.cmo.setUserPreferredServer(bean)

def create_FileStore(path, beanName):
  wl.cd(path)
  try:
    print "creating mbean of type FileStore ... "
    theBean = wl.cmo.lookupFileStore(beanName)
    if theBean == None:
      wl.cmo.createFileStore(beanName)
  except java.lang.UnsupportedOperationException, usoe:
    pass
  except weblogic.descriptor.BeanAlreadyExistsException,bae:
    pass
  except java.lang.reflect.UndeclaredThrowableException,udt:
    pass

def setJMSFileStoreAttributes(domainDirectory, managedServerName, fileStoreName ):
  wl.cd("/FileStores/" + fileStoreName)
  print "setting attributes for mbean type FileStore " + fileStoreName
  wl.set("SynchronousWritePolicy", "Direct-Write")
  
  filestoreLocation = domainDirectory + "/filestores"

  wl.set("Directory", filestoreLocation)
  refBean0 = wl.getMBean("/Servers/" + managedServerName)
  theValue = array([refBean0], Class.forName("weblogic.management.configuration.TargetMBean"))
  wl.cmo.setTargets(theValue)

def create_Realm(path, beanName):
  wl.cd(path)
  try:
    print "creating mbean of type Realm ... "
    theBean = wl.cmo.lookupRealm(beanName)
    if theBean == None:
      wl.cmo.createRealm(beanName)
  except java.lang.UnsupportedOperationException, usoe:
    pass
  except weblogic.descriptor.BeanAlreadyExistsException,bae:
    pass
  except java.lang.reflect.UndeclaredThrowableException,udt:
    pass

def create_Authorizer(path, beanName):
  wl.cd(path)
  try:
    print "creating mbean of type Authorizer ... "
    theBean = wl.cmo.lookupAuthorizer(beanName)
    if theBean == None:
      wl.cmo.createAuthorizer(beanName,"weblogic.security.providers.xacml.authorization.XACMLAuthorizer")
  except java.lang.UnsupportedOperationException, usoe:
    pass
  except weblogic.descriptor.BeanAlreadyExistsException,bae:
    pass
  except java.lang.reflect.UndeclaredThrowableException,udt:
    pass

def create_Adjudicator(path, beanName):
  wl.cd(path)
  try:
    print "creating mbean of type Adjudicator ... "
    theBean = wl.cmo.getAdjudicator()
    if theBean == None:
      wl.cmo.createAdjudicator(beanName,"weblogic.security.providers.authorization.DefaultAdjudicator")
  except java.lang.UnsupportedOperationException, usoe:
    pass
  except weblogic.descriptor.BeanAlreadyExistsException,bae:
    pass
  except java.lang.reflect.UndeclaredThrowableException,udt:
    pass

def create_AuthenticationProvider(path, beanName):
  wl.cd(path)
  try:
    print "creating mbean of type AuthenticationProvider ... "
    theBean = wl.cmo.lookupAuthenticationProvider(beanName)
    if theBean == None:
      wl.cmo.createAuthenticationProvider(beanName,"weblogic.security.providers.authentication.DefaultAuthenticator")
  except java.lang.UnsupportedOperationException, usoe:
    pass
  except weblogic.descriptor.BeanAlreadyExistsException,bae:
    pass
  except java.lang.reflect.UndeclaredThrowableException,udt:
    pass

def create_CertPathProvider(path, beanName):
  wl.cd(path)
  try:
    print "creating mbean of type CertPathProvider ... "
    theBean = wl.cmo.lookupCertPathProvider(beanName)
    if theBean == None:
      wl.cmo.createCertPathProvider(beanName,"weblogic.security.providers.pk.WebLogicCertPathProvider")
  except java.lang.UnsupportedOperationException, usoe:
    pass
  except weblogic.descriptor.BeanAlreadyExistsException,bae:
    pass
  except java.lang.reflect.UndeclaredThrowableException,udt:
    pass

def create_CredentialMapper(path, beanName):
  wl.cd(path)
  try:
    print "creating mbean of type CredentialMapper ... "
    theBean = wl.cmo.lookupCredentialMapper(beanName)
    if theBean == None:
      wl.cmo.createCredentialMapper(beanName,"weblogic.security.providers.credentials.DefaultCredentialMapper")
  except java.lang.UnsupportedOperationException, usoe:
    pass
  except weblogic.descriptor.BeanAlreadyExistsException,bae:
    pass
  except java.lang.reflect.UndeclaredThrowableException,udt:
    pass

def create_RoleMapper(path, beanName):
  wl.cd(path)
  try:
    print "creating mbean of type RoleMapper ... "
    theBean = wl.cmo.lookupRoleMapper(beanName)
    if theBean == None:
      wl.cmo.createRoleMapper(beanName,"weblogic.security.providers.xacml.authorization.XACMLRoleMapper")
  except java.lang.UnsupportedOperationException, usoe:
    pass
  except weblogic.descriptor.BeanAlreadyExistsException,bae:
    pass
  except java.lang.reflect.UndeclaredThrowableException,udt:
    pass

def create_Machine(path, beanName):
  wl.cd(path)
  try:
    print "creating mbean of type Machine ... "
    theBean = wl.cmo.lookupMachine(beanName)
    if theBean == None:
      wl.cmo.createMachine(beanName)
  except java.lang.UnsupportedOperationException, usoe:
    pass
  except weblogic.descriptor.BeanAlreadyExistsException,bae:
    pass
  except java.lang.reflect.UndeclaredThrowableException,udt:
    pass

def create_Cluster(path, beanName):
  wl.cd(path)
  try:
    print "creating mbean of type Cluster ... "
    theBean = wl.cmo.lookupCluster(beanName)
    if theBean == None:
      wl.cmo.createCluster(beanName)
  except java.lang.UnsupportedOperationException, usoe:
    pass
  except weblogic.descriptor.BeanAlreadyExistsException,bae:
    pass
  except java.lang.reflect.UndeclaredThrowableException,udt:
    pass

def create_JMSServer(path, beanName):
  wl.cd(path)
  try:
    print "creating mbean of type JMSServer ... "
    theBean = wl.cmo.lookupJMSServer(beanName)
    if theBean == None:
      wl.cmo.createJMSServer(beanName)
  except java.lang.UnsupportedOperationException, usoe:
    pass
  except weblogic.descriptor.BeanAlreadyExistsException,bae:
    pass
  except java.lang.reflect.UndeclaredThrowableException,udt:
    pass

def create_JDBCSystemResource(path, beanName):
  wl.cd(path)
  try:
    print "creating mbean of type JDBCSystemResource ... "
    theBean = wl.cmo.lookupJDBCSystemResource(beanName)
    if theBean == None:
      wl.cmo.createJDBCSystemResource(beanName)
  except java.lang.UnsupportedOperationException, usoe:
    pass
  except weblogic.descriptor.BeanAlreadyExistsException,bae:
    pass
  except java.lang.reflect.UndeclaredThrowableException,udt:
    pass

def create_Property(path, beanName):
  wl.cd(path)
  try:
    print "creating mbean of type Property ... "
    theBean = wl.cmo.lookupProperty(beanName)
    if theBean == None:
      wl.cmo.createProperty(beanName)
  except java.lang.UnsupportedOperationException, usoe:
    pass
  except weblogic.descriptor.BeanAlreadyExistsException,bae:
    pass
  except java.lang.reflect.UndeclaredThrowableException,udt:
    pass
  except TypeError:
    prop = cmo.createProperty()
    prop.setName(beanName)

def create_JMSSystemResource(path, beanName):
  wl.cd(path)
  try:
    print "creating mbean of type JMSSystemResource ... "
    theBean = wl.cmo.lookupJMSSystemResource(beanName)
    if theBean == None:
      wl.cmo.createJMSSystemResource(beanName)
  except java.lang.UnsupportedOperationException, usoe:
    pass
  except weblogic.descriptor.BeanAlreadyExistsException,bae:
    pass
  except java.lang.reflect.UndeclaredThrowableException,udt:
    pass

def create_SubDeployment(path, beanName):
  wl.cd(path)
  try:
    print "creating mbean of type SubDeployment ... "
    theBean = wl.cmo.lookupSubDeployment(beanName)
    if theBean == None:
      wl.cmo.createSubDeployment(beanName)
  except java.lang.UnsupportedOperationException, usoe:
    pass
  except weblogic.descriptor.BeanAlreadyExistsException,bae:
    pass
  except java.lang.reflect.UndeclaredThrowableException,udt:
    pass

def create_ConnectionFactory(module, beanName):
  path = "/JMSSystemResources/" +module+ "/JMSResource/" + module
  wl.cd(path)
  try:
    print "creating mbean of type ConnectionFactory ... "
    theBean = wl.cmo.lookupConnectionFactory(beanName)
    if theBean == None:
      wl.cmo.createConnectionFactory(beanName)
  except java.lang.UnsupportedOperationException, usoe:
    pass
  except weblogic.descriptor.BeanAlreadyExistsException,bae:
    pass
  except java.lang.reflect.UndeclaredThrowableException,udt:
    pass

def create_UniformDistributedQueue(module, beanName):
  path = "/JMSSystemResources/" +module+ "/JMSResource/" + module  
  wl.cd(path)
  try:
    print "creating mbean of type UniformDistributedQueue ... "
    theBean = wl.cmo.lookupUniformDistributedQueue(beanName)
    if theBean == None:
      wl.cmo.createUniformDistributedQueue(beanName)
  except java.lang.UnsupportedOperationException, usoe:
    pass
  except weblogic.descriptor.BeanAlreadyExistsException,bae:
    pass
  except java.lang.reflect.UndeclaredThrowableException,udt:
    pass

def setDefaultIdentityAsserterAttributes(domainName):
  wl.cd("/SecurityConfiguration/" + domainName + "/Realms/myrealm/AuthenticationProviders/DefaultIdentityAsserter")
  print "setting attributes for mbean type DefaultIdentityAsserter"
  wl.set("ActiveTypes", array(["AuthenticatedUser"], String))
  
def setClusterAttributes(clusterName, clusterMessagingMode = "unicast"):
  wl.cd("/Clusters/" + clusterName)
  print "setting attributes for mbean type Cluster: " + clusterName
  wl.set("ClusterMessagingMode", clusterMessagingMode)
  
def setJmsServerAttributes(jmsServerName, managedServerName, filestoreName):
  wl.cd("/JMSServers/" + jmsServerName)
  print "setting attributes for mbean type JMSServer: " + jmsServerName
  refBean0 = wl.getMBean("/Servers/" + managedServerName)
  theValue = array([refBean0], Class.forName("weblogic.management.configuration.TargetMBean"))
  wl.cmo.setTargets(theValue)

  bean = wl.getMBean("/FileStores/" + filestoreName)
  wl.cmo.setPersistentStore(bean)
  
def setDataSourceAttributes(dataSourceName, targetPath, userName, jndiName, globalTransactionProtocol = "TwoPhaseCommit"):
  wl.cd("/JDBCSystemResources/" + dataSourceName)
  print "setting attributes for mbean type JDBCSystemResource: " + dataSourceName
  refBean0 = wl.getMBean(targetPath)
  theValue = array([refBean0], Class.forName("weblogic.management.configuration.TargetMBean"))
  wl.cmo.setTargets(theValue)
  
  # set user attributes
  wl.cd("/JDBCSystemResources/" + dataSourceName + "/JDBCResource/" + dataSourceName + "/JDBCDriverParams/" + dataSourceName + "/Properties/" + dataSourceName + "/Properties/user")
  print "setting attributes for mbean type JDBCProperty user"
  wl.set("Value", userName)
  wl.set("Name", "user")
  
  # set data source name
  wl.cd("/JDBCSystemResources/"  + dataSourceName + "/JDBCResource/" + dataSourceName)
  print "setting attributes for mbean type JDBCDataSource: " + dataSourceName
  wl.set("Name", dataSourceName)
  
  wl.cd("/JDBCSystemResources/" +dataSourceName+ "/JDBCResource/" +dataSourceName+ "/JDBCDataSourceParams/" + dataSourceName)
  print "setting attributes for mbean type JDBCDataSourceParams: " + dataSourceName
  wl.set("GlobalTransactionsProtocol", globalTransactionProtocol)
  wl.set("JNDINames", array([jndiName], String))
  
def setJDBCConnectionPoolParamsAttributes(dataSourceName, initialCapacity = "1", maxCapacity = "15", capacityIncrement = "1", testTableName = "SQL SELECT 1 FROM DUAL", statementCacheSize = "10", statementCacheType =  "LRU"):
  wl.cd("/JDBCSystemResources/" +dataSourceName+ "/JDBCResource/" +dataSourceName+ "/JDBCConnectionPoolParams/" + dataSourceName)
  print "setting attributes for mbean type JDBCConnectionPoolParams: " + dataSourceName
  wl.set("StatementCacheSize", statementCacheSize)
  wl.set("TestTableName", testTableName)
  wl.set("MaxCapacity", maxCapacity)
  wl.set("InitialCapacity", initialCapacity)
  wl.set("StatementCacheType", statementCacheType)
  wl.set("CapacityIncrement", capacityIncrement)
  
def setJDBCDriverParamsAttribute(dataSourceName, password, driverName, url):
  wl.cd("/JDBCSystemResources/" +dataSourceName+ "/JDBCResource/" +dataSourceName+ "/JDBCDriverParams/" + dataSourceName)
  print "setting attributes for mbean type JDBCDriverParams: " + dataSourceName
  wl.set("Password", password)
  wl.set("DriverName", driverName)
  wl.set("Url", url)
  
def setJmsModuleAttributes(jmsModuleName, subDeploymentName, targetPath):
  wl.cd("/JMSSystemResources/" + jmsModuleName)
  print "setting attributes for mbean type JMSSystemResource: " + jmsModuleName
  targetBean = wl.getMBean(targetPath)
  theValue = array([targetBean], Class.forName("weblogic.management.configuration.TargetMBean"))
  wl.cmo.setTargets(theValue)
  
  # set sub-deployment attributes
  wl.cd("/JMSSystemResources/" + jmsModuleName + "/SubDeployments/" + subDeploymentName)
  print "setting attributes for mbean type SubDeployment: " + subDeploymentName
  theValue = array([targetBean], Class.forName("weblogic.management.configuration.TargetMBean"))
  wl.cmo.setTargets(theValue)
  
def setQueueConnectionFactoryAttributes(jmsModuleName, queueConnectionFactoryName, jndiName, defaultTargeting = "true", attachJMSXUserId = "true", xaConnectionFactoryEnabled = "false"):
  wl.cd("/JMSSystemResources/" + jmsModuleName + "/JMSResource/" + jmsModuleName + "/ConnectionFactories/" + queueConnectionFactoryName)
  print "setting attributes for mbean type JMSConnectionFactory: " + queueConnectionFactoryName
  wl.set("DefaultTargetingEnabled", defaultTargeting)
  wl.set("Name", queueConnectionFactoryName)
  wl.set("JNDIName", jndiName)
  
  if attachJMSXUserId != "true":
      wl.cd("/JMSSystemResources/" + jmsModuleName + "/JMSResource/" + jmsModuleName + "/ConnectionFactories/" + queueConnectionFactoryName + "/SecurityParams/" + queueConnectionFactoryName)
      #print " setting attachJMSXUserId attribute for JMSConnectionFactory" + queueConnectionFactoryName
      wl.set("AttachJMSXUserId", "false")
      
  wl.cd("/JMSSystemResources/" + jmsModuleName + "/JMSResource/" + jmsModuleName + "/ConnectionFactories/" + queueConnectionFactoryName + "/TransactionParams/" + queueConnectionFactoryName)    
  print "setting attributes for mbean type TransactionParams"
  wl.set("XAConnectionFactoryEnabled", xaConnectionFactoryEnabled)
  
  wl.cd("/JMSSystemResources/" + jmsModuleName + "/JMSResource/" + jmsModuleName + "/ConnectionFactories/" + queueConnectionFactoryName + "/ClientParams/" + queueConnectionFactoryName)
  print "setting attributes for mbean type ClientParams"
  wl.set("MessagesMaximum", "10")                          # TODO: Needs to be configurable?
  wl.set("SubscriptionSharingPolicy", "Exclusive")         # TODO: Needs to be configurable?
  wl.set("ClientIdPolicy", "Restricted")                   # TODO: Needs to be configurable?
  
  
def setQueueAttributes(jmsModule, queueName, subDeploymentName, jndiName, errorDestination, loadBalancingPolicy = "Round-Robin", expiryPolicy = "Redirect", redeliveryLimit = "10"):
  wl.cd("/JMSSystemResources/" +jmsModule+ "/JMSResource/" +jmsModule+ "/UniformDistributedQueues/" + queueName)
  print "setting attributes for mbean type UniformDistributedQueue: " + queueName
  wl.set("LoadBalancingPolicy", loadBalancingPolicy)
  wl.set("Name", queueName)
  wl.set("SubDeploymentName", subDeploymentName)
  wl.set("JNDIName", jndiName)
  
  if expiryPolicy == "Redirect":
    # set delivery failure params on queue
    wl.cd("/JMSSystemResources/" +jmsModule+ "/JMSResource/" +jmsModule+ "/UniformDistributedQueues/" + queueName + "/DeliveryFailureParams/" + queueName)
    print "setting attributes for mbean type DeliveryFailureParams"
    
    #TODO: Come back and fix.
    #set("ExpirationPolicy", expiryPolicy)
    #set("RedeliveryLimit", redeliveryLimit)
    #set("ErrorDestination", errorDestination)
  
  wl.cd("/JMSSystemResources/" +jmsModule+ "/JMSResource/" +jmsModule+ "/UniformDistributedQueues/" + queueName + "/DeliveryParamsOverrides/" + queueName)
  wl.set("RedeliveryDelay", "500")
  
  
def setServerSSLAttributes(serverName, listenPort, enabled = "true"):
  wl.cd("/Servers/" +serverName+ "/SSL/" + serverName)
  print "setting attributes for mbean type SSL: " + serverName + " Listen Port: " + listenPort + " Enabled: " + enabled
  wl.set("Enabled", enabled)
  wl.set("ListenPort", listenPort)
  
def setEmbeddedLDAPAttributes(domainName):
  wl.cd("/EmbeddedLDAP/" + domainName)
  print "setting attributes for mbean type EmbeddedLDAP"
  
  # what are these credentials?
  #setEncrypted("Credential", "c2s67", "/u01/app/domains/vap_dev/./config/c2sConfigvap_dev", "/u01/app/domains/vap_dev/./config/c2sSecretvap_dev")
  #setEncrypted("Credential", "c2s68", "/u01/app/domains/vap_dev/./config/c2sConfigvap_dev", "/u01/app/domains/vap_dev/./config/c2sSecretvap_dev")
  
  
def setSecurityConfigurationAttributes(domainName):
  wl.cd("/SecurityConfiguration/" + domainName)
  print "setting attributes for mbean type SecurityConfiguration"
  #setEncrypted("Credential", "c2s78", "/u01/app/domains/vap_dev/./config/c2sConfigvap_dev", "/u01/app/domains/vap_dev/./config/c2sSecretvap_dev")
  #setEncrypted("NodeManagerPassword", "c2s79", "/u01/app/domains/vap_dev/./config/c2sConfigvap_dev", "/u01/app/domains/vap_dev/./config/c2sSecretvap_dev")
  #setEncrypted("NodeManagerPassword", "c2s80", "/u01/app/domains/vap_dev/./config/c2sConfigvap_dev", "/u01/app/domains/vap_dev/./config/c2sSecretvap_dev")
  #set("NodeManagerUsername", "zKU83Cn3xZ")
  #setEncrypted("Credential", "c2s81", "/u01/app/domains/vap_dev/./config/c2sConfigvap_dev", "/u01/app/domains/vap_dev/./config/c2sSecretvap_dev")
  
def setNodeManagerAttributes(machineName, listenAddress = "localhost", nmType="plain"):
  wl.cd("/Machines/" +machineName+ "/NodeManager/" + machineName)
  print "setting attributes for mbean type NodeManager: " + machineName
  wl.set("ListenAddress", listenAddress)
  wl.set("NMType", nmType)
  
def setJTAMigratableTargetAttributes(serverName, clusterName):
  print serverName + ' ' + clusterName
  wl.cd("/Servers/" +serverName+ "/JTAMigratableTarget/" + serverName)
  print "setting attributes for mbean type JTAMigratableTarget: " + serverName
  bean = wl.getMBean("/Clusters/" + clusterName)
  wl.cmo.setCluster(bean)

  bean = wl.getMBean("/Servers/" + serverName)
  wl.cmo.setUserPreferredServer(bean)
  
def setDomainAttributes(domainName, adminServerName, domainVersion="10.3.5.0", configurationVersion="10.3.5.0", productionMode="false"):
  wl.cd("/")
  print "setting attributes for mbean type Domain"
  wl.set("DomainVersion", domainVersion)
  wl.set("ProductionModeEnabled", productionMode)
  wl.set("ConfigurationVersion", configurationVersion)
  wl.set("AdminServerName", adminServerName)
  
  wl.cd("/JTA/" + domainName)
  # standard JTA settings
  print "setting attributes for mbean type JTA"
  wl.set("BeforeCompletionIterationLimit", "10")
  wl.set("UnregisterResourceGracePeriod", "30")
  wl.set("MaxUniqueNameStatistics", "1000")
  wl.set("ForgetHeuristics", "true")
  wl.set("SecurityInteropMode", "default")
  wl.set("AbandonTimeoutSeconds", "86400")
  wl.set("MaxResourceRequestsOnServer", "50")
  wl.set("MaxXACallMillis", "120000")
  wl.set("CheckpointIntervalSeconds", "300")
  wl.set("TimeoutSeconds", "3000")
  wl.set("MaxTransactions", "10000")
  wl.set("MaxResourceUnavailableMillis", "1800000")
  
def setServerStartAttributes(serverName, arguments, javaVendor = "Sun"):
  wl.cd("/Servers/" + serverName + "/ServerStart/" + serverName)
  print "setting attributes for mbean type ServerStart: " + serverName
  wl.set("Arguments", arguments)
  wl.set("JavaVendor", javaVendor)
  
def deployApplication(appName, path, targets, sm, lm, b):
  wl.deploy(appName,path,targets,securityModel=sm,lm=libraryModule,block=b)
  print 'Done deploying: ', appName
