import sys
import os
from util import params
from util import domainconfig
from util.propertyhelp import PropertyHelper

print "[WLST] ------------------------------------------------------------------------"
print "[WLST] "
print "[WLST] Undeploying Application from Weblogic"
print "[WLST] "

try:
    print "[WLST] ------------------------------------------------------------------------"
    print "[WLST] "
    print "[WLST] Loading Script Parameters"
    print "[WLST] "
    
    scriptParams = params.getScriptParameters(sys.argv)
    propHelp = PropertyHelper(scriptParams['props.file'])
    attrs = propHelp.getAdminServerAttributes()
    domainDirectory = propHelp.getDomainsDirectory(propHelp.getAdminServerAttributes()['machine']) + "/" + domainName

    print "[WLST] ------------------------------------------------------------------------"
    print "[WLST] "
    print "[WLST] Connecting to Admin Server"
    print "[WLST] "
    
    # Read Admin Server Attributes
    adminAttributes = propHelp.getAdminServerAttributes()
    
    # Connect to Admin Server
    try :
        connect(adminAttributes['username'], adminAttributes['password'], adminAttributes['url'])
    except :
        print "[WLST] ------------------------------------------------------------------------"
        print "[WLST] "
        print "[WLST] Error connecting to " + domainName + " Domain Admin Server at URL " + adminAttributes['url']
        print "[WLST] "
        print "[WLST] ------------------------------------------------------------------------"
        dumpVariables()
        dumpStack()
        sys.exit(-1)
    
    # If connected, deploy application.
    if( connected == "true") :
        appName         = scriptParams['appName']

        appInfo = propHelp.getApplicationInfo(appName)
        if(appInfo.get('version') != None) : 
            appName = appName + '#' + appInfo['version']
        if(appInfo.get('versionSpec') != None) :
            appName = appName + '@' + appInfo['versionSpec']
        
        print "[WLST] ------------------------------------------------------------------------"
        print "[WLST] "
        print "[WLST] Undeploying the " + appName + " Enterprise Application."
        print "[WLST]    - Application Location: " + appInfo['path']
        print "[WLST]    - Application Target Servers: " + appInfo['targets']
        print "[WLST] "
        
        # Undeploy any applications that are already deployed
        cd("AppDeployments")
        for i in ls().split() : 
            if( i.count(appName) > 0 ) :
                undeploy(i)
        
        disconnect()
    
except :
    print "[WLST] ------------------------------------------------------------------------"
    print "[WLST] "
    print "[WLST] Unexpected Error Occurred: ",  sys.exc_info()[1]
    print "[WLST] ", sys.exc_info()
    print "[WLST] "
    print "[WLST] ------------------------------------------------------------------------"
    dumpStack()
    dumpVariables()
    sys.exit(-1)

print "[WLST] ------------------------------------------------------------------------"
print "[WLST] "
print "[WLST] Finished undeployment of application"
print "[WLST] "
print "[WLST] ------------------------------------------------------------------------"
