import sys
import os
from util import params
from util import domainconfig
from util.propertyhelp import PropertyHelper

print "[WLST] ------------------------------------------------------------------------"
print "[WLST] "
print "[WLST] Starting WebLogic Servers for Domain"
print "[WLST] "

try:
    print "[WLST] ------------------------------------------------------------------------"
    print "[WLST] "
    print "[WLST] Loading Script Parameters"
    print "[WLST] "
    
    params = params.getScriptParameters(sys.argv)
    propHelp = PropertyHelper(params['props.file'])
    attrs = propHelp.getAdminServerAttributes()
    domainDirectory = propHelp.getDomainsDirectory(propHelp.getAdminServerAttributes()['machine']) + "/" + propHelp.getDomainName()

    print "[WLST] ------------------------------------------------------------------------"
    print "[WLST] "
    print "[WLST] Starting Domain Admin Server"
    print "[WLST] "
    
    # TODO: Determine whether to use nodemanager to start admin server or not. Should it be a configuration option?
    
    # TODO: If the restart flag is present and the server is up, shut it down first and restart.
    if(params.get('restart') == 'true'):
         hideDisplay()
         hideDumpStack("true")

         # try connecting to a running server if it is already running ... 
         if(connected=="false"):
            try:
                connect(attrs['username'], attrs['password'], attrs['url'])
            except WLSTException:
                print 'No server is running at '+adminServer['url']+', the script will start a new server'
  
         hideDumpStack("false")
    
    print "Domain Directory: " + domainDirectory
    # start the server now
    startServer(attrs['name'], propHelp.getDomainName(), attrs['url'], attrs['username'], attrs['password'], domainDirectory, jvmArgs=attrs['jvmargs'])
    
    # TODO: Add logic for starting managed servers
    
except :
    print "[WLST] ------------------------------------------------------------------------"
    print "[WLST] "
    print "[WLST] Unexpected Error Occurred: ",  sys.exc_info()[1]
    print "[WLST] ", sys.exc_info()
    print "[WLST] "
    print "[WLST] ------------------------------------------------------------------------"
    sys.exit(-1)

print "[WLST] ------------------------------------------------------------------------"
print "[WLST] "
print "[WLST] Finished Starting Servers"
print "[WLST] "
print "[WLST] ------------------------------------------------------------------------"
