import sys
import os

try :
    
    params = {}
    
    print "Parsing command line parameters."
    for arg in sys.argv :
        if( arg.find('-') == 0) :
            # string the leading '-' character
            arg = arg.strip('-')
            
            # check to see if theres an '=' character in the remaining characters
            # if there is, then split the string on the '=' and add it to the map
            if(arg.find('=') != -1) :
                split = arg.split('=')
                params[split[0]] = split[1]
            else :
                params[arg] = True
    
    domainName = params['domainName'] 
    domainUser = params['domainUser']
    domainPassword = params['domainPassword']
    adminUrl = params['adminUrl']
    domainDirectory = params['domainDirectory']
    nodeManagerHome = params['domainManagerHome']
    
    # Connect to the domain's admin server
    print "Connecting to admin server for domain " + domainName + " at " + adminUrl
    connect(domainUser, domainPassword, adminUrl)
    
    # Enroll the machine in the domain
    print "Enrolling this machine in the domain " + domainName
    nmEnroll(domainDirectory, nodeManagerHome)
    
except : 
    print "Unexpected error while enrolling machine in domain. ",  sys.exc_info()[1]
    print ""
    print "Script Usage: wlst.sh nodemgrenroll.py " 
    print "                             -domainName=thedomainname "
    print "                             -domainUser=thedomainuser "
    print "                             -domainPassword=thedomainpassword "
    print "                             -adminUrl=t3://adminhost:adminport "
    print "                             -domainDirectory=/path/to/domain/directory "
    print "                             -domainManagerHome=/path/to/node/manager/home"
    
      