import sys
import os
from util import params
from util import domainconfig
from util.propertyhelp import PropertyHelper

print "[WLST] ------------------------------------------------------------------------"
print "[WLST] "
print "[WLST] Deploying Application to Weblogic"
print "[WLST] "

try:
    print "[WLST] ------------------------------------------------------------------------"
    print "[WLST] "
    print "[WLST] Loading Script Parameters"
    print "[WLST] "
    
    scriptParams = params.getScriptParameters(sys.argv)
    propHelp = PropertyHelper(scriptParams['props.file'])
    attrs = propHelp.getAdminServerAttributes()
    domainDirectory = propHelp.getDomainsDirectory(propHelp.getAdminServerAttributes()['machine']) + "/" + domainName

    print "[WLST] ------------------------------------------------------------------------"
    print "[WLST] "
    print "[WLST] Connecting to Admin Server"
    print "[WLST] "
    
    # Read Admin Server Attributes
    adminAttributes = propHelp.getAdminServerAttributes()
    
    # Connect to Admin Server
    try :
        connect(adminAttributes['username'], adminAttributes['password'], adminAttributes['url'])
    except :
        print "[WLST] ------------------------------------------------------------------------"
        print "[WLST] "
        print "[WLST] Error connecting to " + domainName + " Domain Admin Server at URL " + adminAttributes['url']
        print "[WLST] "
        print "[WLST] ------------------------------------------------------------------------"
        dumpVariables()
        dumpStack()
        sys.exit(-1)
    
    # If connected, deploy application.
    if( connected == "true") :
        appName         = scriptParams['appName']
#        appPackage      = scriptParams['appPackage']
#        appVersion      = scriptParams['appVersion']
#        appType         = scriptParams['appType']
#        appTargets      = scriptParams['appTargets']
#        appPath = os.getenv('M2_REPO') + "/" + appPackage + "/"  + appName + "/"  + appVersion  + "/"  + appName  + "-"  + appVersion  + "."  + appType

        appInfo = propHelp.getApplicationInfo(appName)
        if(appInfo.get('version') != None) : 
            appName = appName + '#' + appInfo['version']
        if(appInfo.get('versionSpec') != None) :
            appName = appName + '@' + appInfo['versionSpec']
        
        print "[WLST] ------------------------------------------------------------------------"
        print "[WLST] "
        print "[WLST] Deploying the " + appName + " Enterprise Application."
        print "[WLST]    - Application Location: " + appInfo['path']
        print "[WLST]    - Application Target Servers: " + appInfo['targets']
        print "[WLST] "
        
        # Deploy the new version of the application
        deploy(appName, appInfo['path'], appInfo['targets'], securityModel=appInfo.get('securityModel', 'DDOnly'), libraryModule=appInfo.get('libraryModule', 'false'), block=appInfo.get('block', 'true'), upload='true')

        # Start the application
        if(appInfo.get('libraryModule', 'false') != 'true') :
            startApplication(appName)
        
        disconnect()
    
except :
    print "[WLST] ------------------------------------------------------------------------"
    print "[WLST] "
    print "[WLST] Unexpected Error Occurred: ",  sys.exc_info()[1]
    print "[WLST] ", sys.exc_info()
    print "[WLST] "
    print "[WLST] ------------------------------------------------------------------------"
    dumpStack()
    dumpVariables()
    sys.exit(-1)

print "[WLST] ------------------------------------------------------------------------"
print "[WLST] "
print "[WLST] Finished Application Deployment"
print "[WLST] "
print "[WLST] ------------------------------------------------------------------------"
