import sys
import os
from util import params
from util import configure
from util.propertyhelp import PropertyHelper


try :
    
    print "[WLST] ------------------------------------------------------------------------"
    print "[WLST] "
    print "[WLST] Configuring WebLogic Server Domain from Template"
    print "[WLST] "
    
    params = params.getScriptParameters(sys.argv)
    
    homeFolder = os.environ['HOME']
    appName = params['app.name']
    propsFile = params['props.file']
    propsPath = homeFolder + '/' + appName + '/' + propsFile
    
    loadProperties(propsPath)
    
    templateName = params['template']
    
    print "[WLST] ------------------------------------------------------------------------"
    print "[WLST] "
    print "[WLST] Application Properties Loaded"    
    print "[WLST]  - Application Name: "            + appName
    print "[WLST]  - Template Name: "               + templateName
    print "[WLST]  - Default Username: "            + defaultUser
    print "[WLST]  - Default Password: "            + defaultPassword
    print "[WLST]  - Temporary Template Name: "     + tempTemplateName
    print "[WLST]  - Domain Directory: " 
    print "[WLST] "
    print "[WLST] "
    print "[WLST] Reading Template from File: " + templateName
    print "[WLST] "
    print "[WLST] ------------------------------------------------------------------------"
    print "[WLST] "
    
    readTemplate(templateName)
    
    print "[WLST] "
    print "[WLST] Modifying the Domain to Suite the Environment"
    print "[WLST] "
    print "[WLST] ------------------------------------------------------------------------"
    print "[WLST] "
     
    # TODO: Browse and Edit Commands go here
    #   1) Update Domain Settings         -> ?/app.name/app.domain.properties
    setDomainAttributes()
    
    #   1) Update Machine Settings        -> ~/app.name/machines.properties
    #   2) Update Cluster Settings        -> ~/app.name/clusters.properties
    #   3) Update JMS Settings            -> ~/app.name/jms.properties
    #   4) Update JDBC Settings           -> ~/app.name/jdbc.settings
    
    
    print "[WLST] "
    print "[WLST] Resetting the Password for the Default Users - User: " + defaultUser
    print "[WLST] "
    print "[WLST] ------------------------------------------------------------------------"
    print "[WLST] "
    
    cd('/Security/' + domainName + '/User/' + defaultUser)
    cmo.setPassword(defaultPassword)
    
    print ""
    print "4: Write Edited Domain to Temporary File"
    print ""
    writeTemplate(tempTemplateName)
    
    print ""
    print "5. Create the Domain"
    print ""
    createDomain(tempTemplateName, domainDir, defaultUser, defaultPassword)
    
except :
    print "Unexpect Error Occured while Configuring the Domain"
    dumpStack()
    for excInfo in sys.exc_info():
        print " ", excInfo
    