import sys
import os
from util import params
from util import domainconfig
from util.propertyhelp import PropertyHelper

try:
    print "[WLST] ------------------------------------------------------------------------"
    print "[WLST] "
    print "[WLST] Loading Script Parameters"
    print "[WLST] "
    
    params = params.getScriptParameters(sys.argv)
    
    pc = PropertyHelper(params['props.file'])
    overwriteDomain = params['overwrite']
    domainName = pc.getDomainName()
    domainDirectory = pc.getDomainsDirectory(pc.getAdminServerAttributes()['machine']) + "/" + domainName
    domainExists = None
    
    print "[WLST] ------------------------------------------------------------------------"
    print "[WLST] "
    print "[WLST]  Script Parameters Loaded"
    print "[WLST]     Domain Name: " + domainName
    print "[WLST]     Domain Directory:" + domainDirectory
    print "[WLST]     Application Name: " + pc.getAppName()
    print "[WLST] "
    
    
    print "Parameters set successfully."
    
    if (File(domainDirectory).exists() == 1) :
        domainExists = True
    else :  
        domainExists = False

    if(overwriteDomain == "false" and domainExists) :
        raise IllegalArgumentException("Domain directory exists.")
    
    print "Domain doesn't exist."
    
    domainconfig.initConfigToScriptRun(domainName, domainDirectory, pc.getAdminServerAttributes())
    
    domainconfig.startTransaction()
    
    ##################################################################################
    # Cluster and Machine Creation and Configuration
    # Start - creation of cluster and machines
    ##################################################################################
    
    # Cluster Configuration
    clusters = pc.getClusters()
    print "Printing clusters map:"
    print clusters
    if(clusters != None) :
        for name, c in clusters.iteritems() :
            domainconfig.create_Cluster("/", c['name'])
            domainconfig.setClusterAttributes(c['name'])
        
    # Machine Configuration
    machines = pc.getMachines()
    if(machines != None) :
        for name, m in machines.iteritems() : 
            domainconfig.create_Machine("/", m['name'])
            domainconfig.setNodeManagerAttributes(m['name'], m['listenAddress'], m['nmType'])
    
    # JMS Resource Configuration  
    jmsResources = pc.getJmsResources()
    if(jmsResources != None) :
        for name, jr in jmsResources.iteritems() :
            if(jr.get('moduleName') != None and jr.get('moduleName') != '') :  
                domainconfig.create_JMSSystemResource("/", jr['moduleName'])
                domainconfig.create_SubDeployment("/JMSSystemResources/"+jr['moduleName'], jr['subdeployment'])
                domainconfig.setJmsModuleAttributes(jr['moduleName'], jr['subdeployment'], jr['target'])
    
    ##################################################################################
    #
    # End - creation of cluster and machines
    #
    ##################################################################################
    
    servers = pc.getManagedServers()
    if(servers != None):
        for name, attributes in servers.iteritems() :
            domainconfig.create_Server("/", attributes['name'], attributes['listenPort'], attributes['listenAddress'])
            domainconfig.setManagedServerAttributes(attributes['name'], attributes.get('cluster'), attributes.get('machine'))
            
            if(attributes['isMigratable'] == 'true') :
                domainconfig.create_MigratableTarget("/", attributes['name'] + " (migratable)")
                domainconfig.setMigratableTagetAttributesFor(attributes['name'], attributes.get('cluster'))
                domainconfig.setJTAMigratableTargetAttributes(attributes['name'], attributes.get('cluster'))
            
            if(len(attributes['sslPort']) > 0) :
                domainconfig.setServerSSLAttributes(attributes['name'], attributes['sslPort'])
            
            jvmargs = attributes.get('jvmargs')
            if(jvmargs != None and len(jvmargs) > 0) :    
                domainconfig.setServerStartAttributes(attributes['name'], attributes['jvmargs'])
                
            if(attributes['initJms'] == 'true'):
                machineDomainDirectory = pc.getDomainsDirectoryByMachineName(attributes['machine']) + "/" + domainName
                domainconfig.create_FileStore("/", attributes['fsName'])
                domainconfig.create_JMSServer("/", attributes['jmsServerName'])
                domainconfig.setJMSFileStoreAttributes(machineDomainDirectory, attributes['name'], attributes['fsName'] )
                domainconfig.setJmsServerAttributes(attributes['jmsServerName'], attributes['name'], attributes['fsName'])
                
    
    ##################################################################################
    #
    # End - build the servers from the known properties
    #
    ##################################################################################
    
    
    domainconfig.setDefaultIdentityAsserterAttributes(domainName)
    domainconfig.setDomainAttributes(domainName, pc.getAdminServerAttributes()['name'])
    domainconfig.setEmbeddedLDAPAttributes(domainName)
    #setSecurityConfigurationAttributes(domainName)
    
    # Security Realm Creation and Configuration
    domainconfig.create_Realm("/SecurityConfiguration/" + domainName, "myrealm")
    domainconfig.create_Authorizer("/SecurityConfiguration/" +domainName + "/Realms/myrealm", "XACMLAuthorizer")
    domainconfig.create_Adjudicator("/SecurityConfiguration/"+ domainName +"/Realms/myrealm", "DefaultAdjudicator")
    domainconfig.create_AuthenticationProvider("/SecurityConfiguration/" + domainName +"/Realms/myrealm", "DefaultAuthenticator")
    domainconfig.create_AuthenticationProvider("/SecurityConfiguration/"+ domainName +"/Realms/myrealm", "DefaultIdentityAsserter")
    domainconfig.create_CertPathProvider("/SecurityConfiguration/"+ domainName +"/Realms/myrealm", "WebLogicCertPathProvider")
    domainconfig.create_CredentialMapper("/SecurityConfiguration/"+ domainName +"/Realms/myrealm", "DefaultCredentialMapper")
    domainconfig.create_RoleMapper("/SecurityConfiguration/"+ domainName +"/Realms/myrealm", "XACMLRoleMapper")
    
    ##################################################################################
    #
    # Queue Connection Factory & Queues Creation and Configuration
    # Start - build the connection factories and queues from the known properties
    #
    ##################################################################################
    
    factories = pc.getConnectionFactories()
    if(factories != None) :
        for name, cf in factories.iteritems() :
            domainconfig.create_ConnectionFactory(cf['module'], cf['name'])
            domainconfig.setQueueConnectionFactoryAttributes(cf['module'], cf['name'], cf['jndiName'], xaConnectionFactoryEnabled = cf['xaEnabled'])
    
            
    queues = pc.getQueues()
    if(queues != None):
        for name, q in queues.iteritems() :
            domainconfig.create_UniformDistributedQueue(q['module'], q['name'])
            domainconfig.setQueueAttributes(q['module'], q['name'], q['subdeployment'], q['jndiName'], errorDestination = q['errorDestination'], expiryPolicy = q['expiryPolicy'])
            
            
    ##################################################################################
    #
    # Queue Connection Factory & Queues Creation and Configuration
    # End - build the connection factories and queues from the known properties
    #
    ##################################################################################
    
    ##################################################################################
    #
    # JDBC Datasource Creation and Configuration
    # Start - build the datasources for the domain 
    #
    ##################################################################################
    
    datasources = pc.getDatasources()
    if(datasources != None) :
        for name, ds in datasources.iteritems() :
            domainconfig.create_JDBCSystemResource("/", ds['name'])
            
            userPropPath = "/JDBCSystemResources/"+ds['name']+"/JDBCResource/"+ds['name']+"/JDBCDriverParams/"+ds['name']+"/Properties/"+ds['name']
            domainconfig.create_Property(userPropPath, "user")
            domainconfig.setDataSourceAttributes(ds['name'], ds['target'], ds['username'], ds['jndiName'], ds['txnProtocol'])
            domainconfig.setJDBCConnectionPoolParamsAttributes(ds['name'], ds['initialCapacity'], ds['maxCapacity'], ds['capacityIncrement'], ds['testTableName'], ds['statementCacheSize'], ds['statementCacheType'])
            domainconfig.setJDBCDriverParamsAttribute(ds['name'], ds['password'], ds['driver'], ds['url'])
    
    ##################################################################################
    #
    # JDBC Datasource Creation and Configuration
    # End - build the datasources for the domain 
    #
    ##################################################################################  
    
    ##################################################################################
    #
    # Deploy the JSTL library that the NVAP web application needs to work.
    #
    ##################################################################################
#    appInfo = pc.getApplicationInfo('jstl')
#    try: 
#        print 1
#        print appInfo
#        deployApplication(appInfo['name'] + '#1.2@1.2.0.1', appInfo['path'],appInfo['targets'], appInfo.get('securityModel', 'DDOnly'), appInfo.get('libraryModule', 'false'), appInfo.get('block', 'true'))
#        print 2
#    except: 
#        dumpVariables()
#        dumpStack()
    
    ##################################################################################
    #
    # End deploy JSTL library.
    #
    ##################################################################################
    
    domainconfig.endTransaction()
    
    ##################################################################################
    #
    # Deploy the application to the domain 
    #
    ##################################################################################
    
#    deployments = pc.getDeployments()
#    if(deployments != None) :
#        for name, d in deployments.iteritems() :
#            deployApp(d['name'], d['path'], d['targets'], d['securityModel'], d['libraryModule'], d['block'])
            
    ##################################################################################
    #
    # Enroll each machine in the domain.
    #
    ##################################################################################
    adminAttribs = pc.getAdminServerAttributes()
    machines = pc.getMachines()
    if(machines != None) :
        
        remoteDirectory = '/tmp/' + domainName + '-deploy'
        for name, m in machines.iteritems() :
            if( m['listenAddress'] != 'localhost') :
                try :
                    # ssh IP       'cd /tmp; mkdir vap-deploy;
                    command = "ssh " + m['listenAddress'] + " 'mkdir " + remoteDirectory + "'" 
                    print "Executing Remote Command: " + command
                    os.system(command)
                    
                    # scp nmenroll.py IP      :/tmp/vap-deploy
                    command = "scp nmenroll.py " + m['listenAddress'] +':' + remoteDirectory
                    print "Copying nmenroll.py script to remote system. " + command
                    os.system(command)
                    
                    # ssh IP       '. .bash_profile;cd /tmp/vap-deploy;$MW_HOME/wlserver/common/bin/wlst.sh nmenroll.py -domainName=vap -domainUser=weblogic -domainPassword=weblogic1 -adminUrl=t3://IP            -domainDirectory=$MW_HOME/user_projects/domains/vap -domainManagerHome=$MW_HOME/wlserver/common/nodemanager'
                    command = "ssh " + m['listenAddress'] + " '. .bash_profile;cd " + remoteDirectory + ";$WL_HOME/common/bin/wlst.sh nmenroll.py " 
                    command = command + "-domainName=" + domainName + " "
                    command = command + "-domainUser=" + adminAttribs['username'] + " "
                    command = command + "-domainPassword=" + adminAttribs['password'] + " "
                    command = command + "-adminUrl=" + adminAttribs['url'] + " " 
                    command = command + "-domainDirectory=$DOMAINS_HOME/" + domainName + " " 
                    command = command + "-domainManagerHome=$WL_HOME/common/nodemanager'" 
                    print "Executing Remote Command: " + command
                    os.system(command)
                    
                    # ssh IP       'mkdir $MW_HOME/user_projects/domains/vap/filestores'
                    command = "ssh " + m['listenAddress'] + " '. .bash_profile;mkdir $DOMAINS_HOME/" + domainName + "/filestores'"
                    print "Executing Remote Command: " + command
                    os.system(command)
                    
                    # ssh IP       'rm -rf /tmp/vap-deploy/;ls -la /tmp/vap-deploy'
                    command = "ssh " + m['listenAddress'] + " 'rm -rf " + remoteDirectory + "'"
                    print "Executing Remote Command to Remove Directory"
                    os.system(command)
                    
                except: 
                    print "An unexpected error occured while enrolling the machin in the domain."
                    print ""
                    print sys.exc_info();
                    print "Error value: ", sys.exc_info()[1]
                    pass
            
except :
    print "Unexpected Error Occurred: ",  sys.exc_info()[1]
    print sys.exc_info()
    pass
 
domainconfig.endOfConfigToScriptRun()
print "[WLST] ------------------------------------------------------------------------"
print "[WLST] "
print "[WLST]                 DOMAIN CREATED SUCCESSFULLY                             "
print "[WLST] "
print "[WLST] ------------------------------------------------------------------------"
